/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.JsonConf;
import kotlinx.serialization.json.internal.JsonReader;
import kotlinx.serialization.json.internal.StreamingJsonDecoder;
import kotlinx.serialization.json.internal.StreamingJsonEncoder;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import kotlinx.serialization.json.internal.TreeJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J'\u0010\u0012\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J'\u0010\u0016\u001a\u00020\u0010\"\u0004\b\u0000\u0010\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\f0\u00182\u0006\u0010\u0019\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u001aJ'\u0010\u001b\u001a\u00020\u0014\"\u0004\b\u0000\u0010\f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\f0\u00182\u0006\u0010\u0019\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u001f \u00a8\u0006!"}, d2={"Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/StringFormat;", "configuration", "Lkotlinx/serialization/json/internal/JsonConf;", "(Lkotlinx/serialization/json/internal/JsonConf;)V", "getConfiguration$kotlinx_serialization_json", "()Lkotlinx/serialization/json/internal/JsonConf;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromJsonElement", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/DeserializationStrategy;Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "decodeFromString", "string", "", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "encodeToJsonElement", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lkotlinx/serialization/json/JsonElement;", "encodeToString", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "parseToJsonElement", "Default", "Lkotlinx/serialization/json/JsonImpl;", "Lkotlinx/serialization/json/Json$Default;", "kotlinx-serialization-json"})
public abstract class Json
implements StringFormat {
    @NotNull
    private final JsonConf configuration;
    public static final Default Default = new Default(null);

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.configuration.serializersModule;
    }

    @Override
    @NotNull
    public final <T> String encodeToString(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        StringBuilder result2 = new StringBuilder();
        StreamingJsonEncoder encoder2 = new StreamingJsonEncoder(result2, this, WriteMode.OBJ, new JsonEncoder[WriteMode.values().length]);
        encoder2.encodeSerializableValue(serializer2, value);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "result.toString()");
        return string;
    }

    @Override
    public final <T> T decodeFromString(@NotNull DeserializationStrategy<T> deserializer, @NotNull String string) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(string, "string");
        JsonReader reader = new JsonReader(string);
        StreamingJsonDecoder input2 = new StreamingJsonDecoder(this, WriteMode.OBJ, reader);
        T result2 = input2.decodeSerializableValue(deserializer);
        if (!reader.isDone()) {
            String string2 = "Reader has not consumed the whole input: " + reader;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return result2;
    }

    @NotNull
    public final <T> JsonElement encodeToJsonElement(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        return TreeJsonEncoderKt.writeJson(this, value, serializer2);
    }

    public final <T> T decodeFromJsonElement(@NotNull DeserializationStrategy<T> deserializer, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        Intrinsics.checkNotNullParameter(element, "element");
        return TreeJsonDecoderKt.readJson(this, element, deserializer);
    }

    @NotNull
    public final JsonElement parseToJsonElement(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        return (JsonElement)this.decodeFromString(JsonElementSerializer.INSTANCE, string);
    }

    @NotNull
    public final JsonConf getConfiguration$kotlinx_serialization_json() {
        return this.configuration;
    }

    private Json(JsonConf configuration) {
        this.configuration = configuration;
    }

    public /* synthetic */ Json(JsonConf configuration, DefaultConstructorMarker $constructor_marker) {
        this(configuration);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lkotlinx/serialization/json/Json$Default;", "Lkotlinx/serialization/json/Json;", "()V", "kotlinx-serialization-json"})
    public static final class Default
    extends Json {
        private Default() {
            super(new JsonConf(false, false, false, false, false, null, false, false, null, false, null, 2047, null), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

