/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import org.jetbrains.annotations.NotNull;

public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE;

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context2, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.strictEqualTypesInternal(context2, a, b);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a, KotlinTypeMarker b) {
        if (a == b) {
            return true;
        }
        SimpleTypeMarker simpleA = $this$strictEqualTypesInternal.asSimpleType(a);
        SimpleTypeMarker simpleB = $this$strictEqualTypesInternal.asSimpleType(b);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean strictEqualSimpleTypes(TypeSystemContext $this$strictEqualSimpleTypes, SimpleTypeMarker a, SimpleTypeMarker b) {
        if ($this$strictEqualSimpleTypes.argumentsCount(a) != $this$strictEqualSimpleTypes.argumentsCount(b) || $this$strictEqualSimpleTypes.isMarkedNullable(a) != $this$strictEqualSimpleTypes.isMarkedNullable(b) || $this$strictEqualSimpleTypes.asDefinitelyNotNullType(a) == null != ($this$strictEqualSimpleTypes.asDefinitelyNotNullType(b) == null) || !$this$strictEqualSimpleTypes.areEqualTypeConstructors($this$strictEqualSimpleTypes.typeConstructor(a), $this$strictEqualSimpleTypes.typeConstructor(b))) {
            return false;
        }
        if ($this$strictEqualSimpleTypes.identicalArguments(a, b)) {
            return true;
        }
        int n = 0;
        int n2 = $this$strictEqualSimpleTypes.argumentsCount(a);
        while (n < n2) {
            void i2;
            TypeArgumentMarker aArg = $this$strictEqualSimpleTypes.getArgument(a, (int)i2);
            TypeArgumentMarker bArg = $this$strictEqualSimpleTypes.getArgument(b, (int)i2);
            if ($this$strictEqualSimpleTypes.isStarProjection(aArg) != $this$strictEqualSimpleTypes.isStarProjection(bArg)) {
                return false;
            }
            if (!$this$strictEqualSimpleTypes.isStarProjection(aArg)) {
                if ($this$strictEqualSimpleTypes.getVariance(aArg) != $this$strictEqualSimpleTypes.getVariance(bArg)) {
                    return false;
                }
                if (!this.strictEqualTypesInternal($this$strictEqualSimpleTypes, $this$strictEqualSimpleTypes.getType(aArg), $this$strictEqualSimpleTypes.getType(bArg))) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }

    private AbstractStrictEqualityTypeChecker() {
    }

    static {
        AbstractStrictEqualityTypeChecker abstractStrictEqualityTypeChecker;
        INSTANCE = abstractStrictEqualityTypeChecker = new AbstractStrictEqualityTypeChecker();
    }
}

