/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaToKotlinClassMap {
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    @NotNull
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkNotNullParameter(kotlinFqName, "kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        String string = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue(string, "kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter(string, prefix, "");
        CharSequence charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, '0', false, 2, null)) {
            Integer arity = StringsKt.toIntOrNull(arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName3, "readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        FqName fqName4 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName4, "mutableClassId.asSingleFqName()");
        FqName mutableFqName = fqName4;
        Map map2 = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "mutableClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, readOnlyFqName);
        Map map3 = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = readOnlyFqName.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe2, "readOnlyFqName.toUnsafe()");
        map3.put(fqNameUnsafe2, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName2, "kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkNotNullExpressionValue(classId2, "ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map2 = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "javaClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map2 = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "kotlinFqNameUnsafe.toUnsafe()");
        map2.put(fqNameUnsafe, javaClassId);
    }

    @Nullable
    public final FqName mutableToReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    @Nullable
    public final FqName readOnlyToMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkNotNullExpressionValue(classId2, "ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkNotNullExpressionValue(classId3, "classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private JavaToKotlinClassMap() {
    }

    static {
        int i2;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        JavaToKotlinClassMap javaToKotlinClassMap;
        INSTANCE = javaToKotlinClassMap = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassKind.Function.getPackageFqName().toString() + "." + FunctionClassKind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassKind.KFunction.getPackageFqName().toString() + "." + FunctionClassKind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.SuspendFunction.getPackageFqName().toString() + "." + FunctionClassKind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassKind.KSuspendFunction.getPackageFqName().toString() + "." + FunctionClassKind.KSuspendFunction.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue(classId, "ClassId.topLevel(FqName(\u2026vm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue(fqName2, "FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = fqName2;
        ClassId classId2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkNotNullExpressionValue(classId2, "ClassId.topLevel(FqName(\u2026tlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = classId2;
        ClassId classId3 = ClassId.topLevel(new FqName("kotlin.reflect.KClass"));
        Intrinsics.checkNotNullExpressionValue(classId3, "ClassId.topLevel(FqName(\"kotlin.reflect.KClass\"))");
        K_CLASS_CLASS_ID = classId3;
        CLASS_CLASS_ID = javaToKotlinClassMap.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        PlatformMutabilityMapping[] platformMutabilityMappingArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap2 = javaToKotlinClassMap;
        ClassId classId4 = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue(classId4, "ClassId.topLevel(FqNames.iterable)");
        ClassId classId5 = classId4;
        JvmPrimitiveType[] kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        int $i$f$mutabilityMapping = 0;
        FqName fqName3 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName4 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName4, "kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName4), false);
        platformMutabilityMappingArray[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId6 = ClassId.topLevel(StandardNames.FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue(classId6, "ClassId.topLevel(FqNames.iterator)");
        kotlinReadOnly$iv = classId6;
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        $i$f$mutabilityMapping = 0;
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName6, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName6), false);
        platformMutabilityMappingArray[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId7 = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue(classId7, "ClassId.topLevel(FqNames.collection)");
        kotlinReadOnly$iv = classId7;
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        $i$f$mutabilityMapping = 0;
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName8 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName8, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName8), false);
        platformMutabilityMappingArray[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId8 = ClassId.topLevel(StandardNames.FqNames.list);
        Intrinsics.checkNotNullExpressionValue(classId8, "ClassId.topLevel(FqNames.list)");
        kotlinReadOnly$iv = classId8;
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        $i$f$mutabilityMapping = 0;
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName10, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName10), false);
        platformMutabilityMappingArray[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId9 = ClassId.topLevel(StandardNames.FqNames.set);
        Intrinsics.checkNotNullExpressionValue(classId9, "ClassId.topLevel(FqNames.set)");
        kotlinReadOnly$iv = classId9;
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        $i$f$mutabilityMapping = 0;
        FqName fqName11 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName12, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName11, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName12), false);
        platformMutabilityMappingArray[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId10 = ClassId.topLevel(StandardNames.FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue(classId10, "ClassId.topLevel(FqNames.listIterator)");
        kotlinReadOnly$iv = classId10;
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        $i$f$mutabilityMapping = 0;
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName14 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName14, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName13, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName14), false);
        platformMutabilityMappingArray[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId11 = ClassId.topLevel(StandardNames.FqNames.map);
        Intrinsics.checkNotNullExpressionValue(classId11, "ClassId.topLevel(FqNames.map)");
        kotlinReadOnly$iv = classId11;
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        $i$f$mutabilityMapping = 0;
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName16, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName15, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName16), false);
        platformMutabilityMappingArray[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId12 = ClassId.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue(classId12, "ClassId.topLevel(FqNames\u2026mes.mapEntry.shortName())");
        kotlinReadOnly$iv = classId12;
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        $i$f$mutabilityMapping = 0;
        FqName fqName17 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue(fqName18, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName17, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName18), false);
        platformMutabilityMappingArray[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf(platformMutabilityMappingArray);
        javaToKotlinClassMap.addTopLevel(Object.class, StandardNames.FqNames.any);
        javaToKotlinClassMap.addTopLevel(String.class, StandardNames.FqNames.string);
        javaToKotlinClassMap.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        javaToKotlinClassMap.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        javaToKotlinClassMap.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        javaToKotlinClassMap.addTopLevel(Number.class, StandardNames.FqNames.number);
        javaToKotlinClassMap.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        javaToKotlinClassMap.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        javaToKotlinClassMap.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            javaToKotlinClassMap.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId13 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue(classId13, "ClassId.topLevel(jvmType.wrapperFqName)");
            PrimitiveType primitiveType = jvmType.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)primitiveType, "jvmType.primitiveType");
            ClassId classId14 = ClassId.topLevel(StandardNames.getPrimitiveFqName(primitiveType));
            Intrinsics.checkNotNullExpressionValue(classId14, "ClassId.topLevel(Standar\u2026e(jvmType.primitiveType))");
            javaToKotlinClassMap.add(classId13, classId14);
        }
        for (ClassId classId15 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId16 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId15.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue(classId16, "ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId17 = classId15.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue(classId17, "classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            javaToKotlinClassMap.add(classId16, classId17);
        }
        int classId15 = 0;
        int n = 23;
        while (classId15 < n) {
            ClassId classId18 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i2));
            Intrinsics.checkNotNullExpressionValue(classId18, "ClassId.topLevel(FqName(\u2026m.functions.Function$i\"))");
            javaToKotlinClassMap.add(classId18, StandardNames.getFunctionClassId(i2));
            javaToKotlinClassMap.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i2), K_FUNCTION_CLASS_ID);
            ++i2;
        }
        n = 22;
        for (i2 = 0; i2 < n; ++i2) {
            FunctionClassKind kSuspendFunction = FunctionClassKind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + "." + kSuspendFunction.getClassNamePrefix();
            javaToKotlinClassMap.addKotlinToJava(new FqName(kSuspendFun + i2), K_FUNCTION_CLASS_ID);
        }
        FqName fqName19 = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName19, "FqNames.nothing.toSafe()");
        javaToKotlinClassMap.addKotlinToJava(fqName19, javaToKotlinClassMap.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        private final ClassId javaClass;
        private final ClassId kotlinReadOnly;
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkNotNullParameter(javaClass, "javaClass");
            Intrinsics.checkNotNullParameter(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkNotNullParameter(kotlinMutable, "kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual(this.javaClass, platformMutabilityMapping.javaClass) || !Intrinsics.areEqual(this.kotlinReadOnly, platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual(this.kotlinMutable, platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

