/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.charsets;

import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.charsets.MalformedInputException;
import io.ktor.utils.io.core.AbstractInput;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.core.internal.UTF8Kt;
import io.ktor.utils.io.core.internal.UnsafeKt;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0014\u001a\u00020\u0001*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0001\u001a6\u0010\u001b\u001a\u00020\u0001*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u001a\u001a\u00020\u0001H\u0000\u001a\u001e\u0010 \u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0001\u001a \u0010\"\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020#2\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a \u0010$\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0001H\u0002\u001a\u0018\u0010%\u001a\u00020\u001f*\u00060\rj\u0002`\u000e2\u0006\u0010\u0017\u001a\u00020\u001cH\u0000\u001a0\u0010&\u001a\u00020\u0001*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u001cH\u0000\u001a*\u0010*\u001a\u00020+*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u00012\b\b\u0002\u0010)\u001a\u00020\u0001\u001a(\u0010,\u001a\u00020+*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001H\u0002\u001a\u001e\u0010-\u001a\u00020.*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020/2\u0006\u0010\u0017\u001a\u000200\u001a\f\u00101\u001a\u00020.*\u000202H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\tj\u0002`\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\rj\u0002`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000f\"\u0019\u0010\u0010\u001a\u00020\u0011*\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013*\n\u00103\"\u00020\u00072\u00020\u0007*\n\u00104\"\u00020\t2\u00020\t*\n\u00105\"\u00020\r2\u00020\r*\n\u00106\"\u0002072\u000207\u00a8\u00068"}, d2={"DECODE_CHAR_BUFFER_SIZE", "", "EmptyByteBuffer", "Ljava/nio/ByteBuffer;", "EmptyCharBuffer", "Ljava/nio/CharBuffer;", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "Ljava/nio/charset/CharsetDecoder;", "Lio/ktor/utils/io/charsets/CharsetDecoder;", "getCharset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetEncoder;", "Lio/ktor/utils/io/charsets/CharsetEncoder;", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "name", "", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "decode", "input", "Lio/ktor/utils/io/core/Input;", "dst", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "decodeBuffer", "Lio/ktor/utils/io/core/Buffer;", "out", "lastBuffer", "", "decodeExactBytes", "inputLength", "decodeImplByteBuffer", "Lio/ktor/utils/io/core/AbstractInput;", "decodeImplSlow", "encodeComplete", "encodeImpl", "", "fromIndex", "toIndex", "encodeToByteArray", "", "encodeToByteArraySlow", "encodeUTF8", "", "Lio/ktor/utils/io/core/ByteReadPacket;", "Lio/ktor/utils/io/core/Output;", "throwExceptionWrapped", "Ljava/nio/charset/CoderResult;", "Charset", "CharsetDecoder", "CharsetEncoder", "Charsets", "Lkotlin/text/Charsets;", "ktor-io"})
public final class CharsetJVMKt {
    private static final int DECODE_CHAR_BUFFER_SIZE = 8192;
    private static final CharBuffer EmptyCharBuffer;
    private static final ByteBuffer EmptyByteBuffer;

    public static /* synthetic */ void Charset$annotations() {
    }

    @NotNull
    public static final String getName(@NotNull Charset $this$name) {
        Intrinsics.checkNotNullParameter($this$name, "$this$name");
        String string = $this$name.name();
        Intrinsics.checkNotNullExpressionValue(string, "name()");
        return string;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetEncoder $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "$this$charset");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNullExpressionValue(charset, "charset()");
        return charset;
    }

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull CharsetEncoder $this$encodeToByteArray, @NotNull CharSequence input2, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter($this$encodeToByteArray, "$this$encodeToByteArray");
        Intrinsics.checkNotNullParameter(input2, "input");
        if (input2 instanceof String) {
            if (fromIndex == 0 && toIndex == input2.length()) {
                byte[] byArray = ((String)input2).getBytes($this$encodeToByteArray.charset());
                Intrinsics.checkNotNullExpressionValue(byArray, "(input as java.lang.String).getBytes(charset())");
                return byArray;
            }
            String string = (String)input2;
            boolean bl = false;
            String string2 = string.substring(fromIndex, toIndex);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes($this$encodeToByteArray.charset());
            Intrinsics.checkNotNullExpressionValue(byArray, "(input.substring(fromInd\u2026ring).getBytes(charset())");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow($this$encodeToByteArray, input2, fromIndex, toIndex);
    }

    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n, n2);
    }

    private static final byte[] encodeToByteArraySlow(CharsetEncoder $this$encodeToByteArraySlow, CharSequence input2, int fromIndex, int toIndex) {
        byte[] existingArray;
        Object object;
        byte[] it;
        boolean bl;
        boolean bl2;
        byte[] byArray;
        ByteBuffer result2 = $this$encodeToByteArraySlow.encode(CharBuffer.wrap(input2, fromIndex, toIndex));
        if (result2.hasArray() && result2.arrayOffset() == 0) {
            byte[] byArray2 = result2.array();
            if (byArray2 != null) {
                byArray = byArray2;
                bl2 = false;
                bl = false;
                it = byArray;
                boolean bl3 = false;
                object = it.length == result2.remaining() ? byArray : null;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        byte[] byArray3 = existingArray = object;
        if (existingArray == null) {
            byArray = new byte[result2.remaining()];
            bl2 = false;
            bl = false;
            it = byArray;
            boolean bl4 = false;
            result2.get(it);
            byArray3 = byArray;
        }
        return byArray3;
    }

    /*
     * WARNING - void declaration
     */
    public static final int encodeImpl(@NotNull CharsetEncoder $this$encodeImpl, @NotNull CharSequence input2, int fromIndex, int toIndex, @NotNull Buffer dst) {
        CoderResult result2;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter($this$encodeImpl, "$this$encodeImpl");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(dst, "dst");
        CharBuffer cb = CharBuffer.wrap(input2, fromIndex, toIndex);
        int before = cb.remaining();
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        boolean bl = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        boolean bl2 = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb2 = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        CoderResult coderResult = result2 = $this$encodeImpl.encode(cb, bb2, false);
        Intrinsics.checkNotNullExpressionValue(coderResult, "result");
        if (coderResult.isMalformed() || result2.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(result2);
        }
        boolean bl5 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return before - cb.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encodeUTF8(@NotNull CharsetEncoder $this$encodeUTF8, @NotNull ByteReadPacket input2, @NotNull Output dst) {
        Intrinsics.checkNotNullParameter($this$encodeUTF8, "$this$encodeUTF8");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(dst, "dst");
        if (CharsetJVMKt.getCharset($this$encodeUTF8) == Charsets.UTF_8) {
            OutputKt.writePacket(dst, input2);
            return;
        }
        ChunkBuffer tmp = ChunkBuffer.Companion.getPool().borrow();
        int readSize = 1;
        try {
            int rc$iv$iv;
            boolean bl;
            int n;
            int $i$f$write;
            void endExclusive$iv;
            void start$iv;
            ByteBuffer nioBuffer$iv;
            void $this$writeDirect$iv;
            Buffer buffer = tmp;
            boolean size$iv = false;
            boolean $i$f$writeDirect = false;
            boolean bl2 = false;
            void $this$write$iv$iv = $this$writeDirect$iv;
            boolean $i$f$write2 = false;
            boolean bl3 = false;
            int n2 = $this$write$iv$iv.getLimit();
            int n3 = $this$write$iv$iv.getWritePosition();
            ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
            boolean bl4 = false;
            ByteBuffer tmpBb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
            boolean bl5 = false;
            CharBuffer charBuffer = tmpBb.asCharBuffer();
            Intrinsics.checkNotNull(charBuffer);
            CharBuffer cb = charBuffer;
            while (input2.getRemaining() > 0L) {
                int i$iv;
                int n4;
                boolean bl6;
                ChunkBuffer chunk;
                block44: {
                    void endExclusive$iv2;
                    void start$iv2;
                    cb.clear();
                    chunk = input2.prepareReadHead(readSize);
                    if (chunk == null) {
                        break;
                    }
                    Buffer $this$decodeUTF8$iv = chunk;
                    boolean $i$f$decodeUTF8 = false;
                    int byteCount$iv = 0;
                    int value$iv = 0;
                    int lastByteCount$iv = 0;
                    Buffer $this$read$iv$iv = $this$decodeUTF8$iv;
                    boolean $i$f$read = false;
                    boolean bl7 = false;
                    int n5 = $this$read$iv$iv.getWritePosition();
                    int n6 = $this$read$iv$iv.getReadPosition();
                    ByteBuffer memory$iv2 = $this$read$iv$iv.getMemory-SK3TCg8();
                    boolean bl8 = false;
                    void var32_54 = start$iv2;
                    bl6 = endExclusive$iv2;
                    while (var32_54 < bl6) {
                        void index$iv;
                        block49: {
                            block52: {
                                block53: {
                                    boolean bl9;
                                    boolean bl10;
                                    boolean bl11;
                                    char ch;
                                    block51: {
                                        boolean bl12;
                                        int v$iv;
                                        block50: {
                                            int $i$f$loadAt;
                                            int n7;
                                            block48: {
                                                boolean bl13;
                                                ByteBuffer $this$get$iv$iv = memory$iv2;
                                                n7 = 0;
                                                ByteBuffer $this$iv$iv$iv = $this$get$iv$iv;
                                                $i$f$loadAt = 0;
                                                v$iv = $this$iv$iv$iv.get((int)index$iv) & 0xFF;
                                                if ((v$iv & 0x80) != 0) break block48;
                                                if (byteCount$iv != 0) {
                                                    Void void_ = UTF8Kt.malformedByteCount(byteCount$iv);
                                                    throw new KotlinNothingValueException();
                                                }
                                                ch = (char)v$iv;
                                                bl11 = false;
                                                if (cb.hasRemaining()) {
                                                    cb.put(ch);
                                                    bl13 = true;
                                                } else {
                                                    bl13 = false;
                                                }
                                                if (!bl13) {
                                                    $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                                    n4 = -1;
                                                    break block44;
                                                }
                                                break block49;
                                            }
                                            if (byteCount$iv != 0) break block50;
                                            int mask$iv = 128;
                                            value$iv = v$iv;
                                            n7 = 1;
                                            int $this$iv$iv$iv = 6;
                                            while (n7 <= $this$iv$iv$iv && (value$iv & mask$iv) != 0) {
                                                value$iv &= ~mask$iv;
                                                mask$iv >>= 1;
                                                $i$f$loadAt = byteCount$iv;
                                                byteCount$iv = $i$f$loadAt + 1;
                                                ++i$iv;
                                            }
                                            lastByteCount$iv = byteCount$iv;
                                            i$iv = byteCount$iv;
                                            byteCount$iv = i$iv + -1;
                                            if (lastByteCount$iv > endExclusive$iv2 - index$iv) {
                                                $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2));
                                                n4 = lastByteCount$iv;
                                                break block44;
                                            }
                                            break block49;
                                        }
                                        value$iv = value$iv << 6 | v$iv & 0x7F;
                                        int mask$iv = byteCount$iv;
                                        if ((byteCount$iv = mask$iv + -1) != 0) break block49;
                                        if (!UTF8Kt.isBmpCodePoint(value$iv)) break block51;
                                        ch = (char)value$iv;
                                        bl11 = false;
                                        if (cb.hasRemaining()) {
                                            cb.put(ch);
                                            bl12 = true;
                                        } else {
                                            bl12 = false;
                                        }
                                        if (!bl12) {
                                            $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                            n4 = -1;
                                            break block44;
                                        }
                                        break block52;
                                    }
                                    if (!UTF8Kt.isValidCodePoint(value$iv)) {
                                        Void void_ = UTF8Kt.malformedCodePoint(value$iv);
                                        throw new KotlinNothingValueException();
                                    }
                                    ch = (char)UTF8Kt.highSurrogate(value$iv);
                                    bl11 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl10 = true;
                                    } else {
                                        bl10 = false;
                                    }
                                    if (!bl10) break block53;
                                    ch = (char)UTF8Kt.lowSurrogate(value$iv);
                                    bl11 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl9 = true;
                                    } else {
                                        bl9 = false;
                                    }
                                    if (bl9) break block52;
                                }
                                $this$decodeUTF8$iv.discardExact((int)(index$iv - start$iv2 - lastByteCount$iv + true));
                                n4 = -1;
                                break block44;
                            }
                            value$iv = 0;
                        }
                        ++index$iv;
                    }
                    void rc$iv$iv2 = endExclusive$iv2 - start$iv2;
                    $this$read$iv$iv.discardExact((int)rc$iv$iv2);
                    n4 = 0;
                }
                int rc2 = n4;
                input2.setHeadPosition(chunk.getReadPosition());
                cb.flip();
                int writeSize = 1;
                if (cb.hasRemaining()) {
                    Output $this$writeWhileSize$iv = dst;
                    int initialSize$iv = 1;
                    boolean $i$f$writeWhileSize = false;
                    ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize$iv, initialSize$iv, null);
                    try {
                        int size$iv2 = 0;
                        while (true) {
                            CoderResult cr;
                            void endExclusive$iv3;
                            void start$iv3;
                            ByteBuffer nioBuffer$iv2;
                            void $this$writeDirect$iv2;
                            Buffer view = tail$iv;
                            boolean bl14 = false;
                            Buffer endExclusive$iv2 = view;
                            int size$iv3 = writeSize;
                            boolean $i$f$writeDirect2 = false;
                            boolean bl8 = false;
                            void $this$write$iv$iv2 = $this$writeDirect$iv2;
                            $i$f$write = 0;
                            bl6 = false;
                            int mask$iv = $this$write$iv$iv2.getLimit();
                            i$iv = $this$write$iv$iv2.getWritePosition();
                            ByteBuffer memory$iv3 = $this$write$iv$iv2.getMemory-SK3TCg8();
                            $i$a$-write-IoBufferJVMKt$writeDirect$2$iv = false;
                            ByteBuffer to = nioBuffer$iv2 = Memory.slice-SK3TCg8(memory$iv3, (int)start$iv3, (int)(endExclusive$iv3 - start$iv3));
                            boolean bl15 = false;
                            CoderResult coderResult = cr = $this$encodeUTF8.encode(cb, to, false);
                            Intrinsics.checkNotNullExpressionValue(coderResult, "cr");
                            if (coderResult.isUnmappable() || cr.isMalformed()) {
                                CharsetJVMKt.throwExceptionWrapped(cr);
                            }
                            if (cr.isOverflow() && to.hasRemaining()) {
                                n = writeSize;
                                writeSize = n + 1;
                            } else {
                                writeSize = 1;
                            }
                            bl = nioBuffer$iv2.limit() == endExclusive$iv3 - start$iv3;
                            boolean bl16 = false;
                            boolean bl17 = false;
                            if (!bl) {
                                boolean bl18 = false;
                                String string = "Buffer's limit change is not allowed";
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            rc$iv$iv = nioBuffer$iv2.position();
                            $this$write$iv$iv2.commitWritten(rc$iv$iv);
                            int n8 = size$iv2 = cb.hasRemaining() ? writeSize : 0;
                            if (size$iv2 <= 0) {
                                break;
                            }
                            tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize$iv, size$iv2, tail$iv);
                        }
                    }
                    finally {
                        UnsafeKt.afterHeadWrite($this$writeWhileSize$iv, tail$iv);
                    }
                }
                if (rc2 <= 0) continue;
                readSize = rc2;
                break;
            }
            cb.clear();
            cb.flip();
            int completeSize = 1;
            Output $this$writeWhileSize$iv = dst;
            int initialSize$iv = 1;
            boolean $i$f$writeWhileSize = false;
            ChunkBuffer tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize$iv, initialSize$iv, null);
            try {
                int size$iv4 = 0;
                while (true) {
                    CoderResult cr;
                    void endExclusive$iv4;
                    void start$iv4;
                    ByteBuffer nioBuffer$iv3;
                    void $this$writeDirect$iv3;
                    Buffer chunk = tail$iv;
                    boolean bl19 = false;
                    Buffer view = chunk;
                    int size$iv5 = completeSize;
                    boolean $i$f$writeDirect3 = false;
                    boolean size$iv3 = false;
                    void $this$write$iv$iv3 = $this$writeDirect$iv3;
                    boolean $i$f$write3 = false;
                    boolean $this$write$iv$iv2 = false;
                    $i$f$write = $this$write$iv$iv3.getLimit();
                    rc$iv$iv = $this$write$iv$iv3.getWritePosition();
                    ByteBuffer memory$iv4 = $this$write$iv$iv3.getMemory-SK3TCg8();
                    $i$a$-write-IoBufferJVMKt$writeDirect$2$iv = false;
                    ByteBuffer to = nioBuffer$iv3 = Memory.slice-SK3TCg8(memory$iv4, (int)start$iv4, (int)(endExclusive$iv4 - start$iv4));
                    boolean bl20 = false;
                    CoderResult coderResult = cr = $this$encodeUTF8.encode(cb, to, true);
                    Intrinsics.checkNotNullExpressionValue(coderResult, "cr");
                    if (coderResult.isMalformed() || cr.isUnmappable()) {
                        CharsetJVMKt.throwExceptionWrapped(cr);
                    }
                    if (cr.isOverflow()) {
                        int n9 = completeSize;
                        completeSize = n9 + 1;
                    } else {
                        completeSize = 0;
                    }
                    boolean bl21 = nioBuffer$iv3.limit() == endExclusive$iv4 - start$iv4;
                    n = 0;
                    bl = false;
                    if (!bl21) {
                        boolean bl22 = false;
                        String string = "Buffer's limit change is not allowed";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    int rc$iv$iv3 = nioBuffer$iv3.position();
                    $this$write$iv$iv3.commitWritten(rc$iv$iv3);
                    size$iv4 = completeSize;
                    if (size$iv4 <= 0) {
                        break;
                    }
                    tail$iv = UnsafeKt.prepareWriteHead($this$writeWhileSize$iv, size$iv4, tail$iv);
                }
            }
            finally {
                UnsafeKt.afterHeadWrite($this$writeWhileSize$iv, tail$iv);
            }
            boolean bl23 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
            boolean bl24 = false;
            boolean bl25 = false;
            if (!bl23) {
                boolean bl26 = false;
                String string = "Buffer's limit change is not allowed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            int rc$iv$iv4 = nioBuffer$iv.position();
            $this$write$iv$iv.commitWritten(rc$iv$iv4);
        }
        finally {
            tmp.release(ChunkBuffer.Companion.getPool());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean encodeComplete(@NotNull CharsetEncoder $this$encodeComplete, @NotNull Buffer dst) {
        CoderResult result2;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        void $this$writeDirect$iv;
        Intrinsics.checkNotNullParameter($this$encodeComplete, "$this$encodeComplete");
        Intrinsics.checkNotNullParameter(dst, "dst");
        boolean completed = false;
        Buffer buffer = dst;
        boolean size$iv = false;
        boolean $i$f$writeDirect = false;
        boolean bl = false;
        void $this$write$iv$iv = $this$writeDirect$iv;
        boolean $i$f$write = false;
        boolean bl2 = false;
        int n = $this$write$iv$iv.getLimit();
        int n2 = $this$write$iv$iv.getWritePosition();
        ByteBuffer memory$iv = $this$write$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb2 = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        CoderResult coderResult = result2 = $this$encodeComplete.encode(EmptyCharBuffer, bb2, true);
        Intrinsics.checkNotNullExpressionValue(coderResult, "result");
        if (coderResult.isMalformed() || result2.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(result2);
        }
        if (result2.isUnderflow()) {
            completed = true;
        }
        boolean bl5 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl6 = false;
        boolean bl7 = false;
        if (!bl5) {
            boolean bl8 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$write$iv$iv.commitWritten(rc$iv$iv);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final int decodeBuffer(@NotNull CharsetDecoder $this$decodeBuffer, @NotNull Buffer input2, @NotNull Appendable out2, boolean lastBuffer, int max) {
        int charactersCopied;
        void endExclusive$iv;
        void start$iv;
        ByteBuffer nioBuffer$iv;
        Intrinsics.checkNotNullParameter($this$decodeBuffer, "$this$decodeBuffer");
        Intrinsics.checkNotNullParameter(input2, "input");
        Intrinsics.checkNotNullParameter(out2, "out");
        Buffer $this$readDirect$iv = input2;
        boolean $i$f$readDirect = false;
        boolean bl = false;
        Buffer $this$read$iv$iv = $this$readDirect$iv;
        boolean $i$f$read = false;
        boolean bl2 = false;
        int n = $this$read$iv$iv.getWritePosition();
        int n2 = $this$read$iv$iv.getReadPosition();
        ByteBuffer memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
        boolean bl3 = false;
        ByteBuffer bb2 = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
        boolean bl4 = false;
        ChunkBuffer tmpBuffer = ChunkBuffer.Companion.getPool().borrow();
        CharBuffer charBuffer = tmpBuffer.getMemory-SK3TCg8().asCharBuffer();
        Intrinsics.checkNotNull(charBuffer);
        CharBuffer cb = charBuffer;
        try {
            int partSize;
            for (charactersCopied = 0; bb2.hasRemaining() && charactersCopied < max; charactersCopied += partSize) {
                CoderResult result2;
                int n3 = cb.capacity();
                int n4 = max - charactersCopied;
                boolean bl5 = false;
                partSize = Math.min(n3, n4);
                cb.clear();
                cb.limit(partSize);
                CoderResult coderResult = result2 = $this$decodeBuffer.decode(bb2, cb, lastBuffer);
                Intrinsics.checkNotNullExpressionValue(coderResult, "result");
                if (!coderResult.isMalformed() && !result2.isUnmappable()) continue;
                CharsetJVMKt.throwExceptionWrapped(result2);
            }
        }
        finally {
            tmpBuffer.release(ChunkBuffer.Companion.getPool());
        }
        boolean bl6 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "Buffer's limit change is not allowed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int rc$iv$iv = nioBuffer$iv.position();
        $this$read$iv$iv.discardExact(rc$iv$iv);
        return charactersCopied;
    }

    public static /* synthetic */ int decodeBuffer$default(CharsetDecoder charsetDecoder, Buffer buffer, Appendable appendable, boolean bl, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return CharsetJVMKt.decodeBuffer(charsetDecoder, buffer, appendable, bl, n);
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetDecoder $this$charset) {
        Intrinsics.checkNotNullParameter($this$charset, "$this$charset");
        Charset charset = $this$charset.charset();
        Intrinsics.checkNotNull(charset);
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static final int decode(@NotNull CharsetDecoder $this$decode, @NotNull Input input, @NotNull Appendable dst, int max) {
        block22: {
            block23: {
                Intrinsics.checkNotNullParameter($this$decode, "$this$decode");
                Intrinsics.checkNotNullParameter(input, "input");
                Intrinsics.checkNotNullParameter(dst, "dst");
                copied = 0;
                cb = CharBuffer.allocate(8192);
                readSize = 1;
                $this$takeWhileSize$iv = input;
                initialSize$iv = 1;
                $i$f$takeWhileSize = false;
                release$iv = true;
                v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize$iv, initialSize$iv);
                if (v0 != null) break block23;
                break block22;
            }
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block25: {
                        block24: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize-CharsetJVMKt$decode$1 = false;
                                    rem = max - copied;
                                    if (rem == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        var21_29 = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var23_31 = false;
                                        var24_32 = $this$read$iv$iv.getWritePosition();
                                        var25_33 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-IoBufferJVMKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decode$1$1 = false;
                                        cb.clear();
                                        if (rem < 8192) {
                                            cb.limit(rem);
                                        }
                                        rc = $this$decode.decode(bb, cb, false);
                                        cb.flip();
                                        copied += cb.remaining();
                                        dst.append(cb);
                                        v2 = rc;
                                        Intrinsics.checkNotNullExpressionValue(v2, "rc");
                                        if (v2.isMalformed() || rc.isUnmappable()) {
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        if (rc.isUnderflow() && bb.hasRemaining()) {
                                            var32_40 = readSize;
                                            readSize = var32_40 + 1;
                                        } else {
                                            readSize = 1;
                                        }
                                        var33_41 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
                                        var34_42 = false;
                                        var35_43 = false;
                                        if (!var33_41) {
                                            $i$a$-check-IoBufferJVMKt$readDirect$2$1$iv = false;
                                            var35_44 = "Buffer's limit change is not allowed";
                                            throw (Throwable)new IllegalStateException(var35_44.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block24;
                            v3 = UnsafeKt.prepareReadNextHead($this$takeWhileSize$iv, current$iv);
                            break block25;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize$iv, current$iv);
                            v3 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize$iv, size$iv);
                        } else {
                            v3 = next$iv = current$iv;
                        }
                    }
                    if (next$iv == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize$iv, current$iv);
                }
            }
        }
        do {
            cb.clear();
            rem = max - copied;
            if (rem == 0) break;
            if (rem < 8192) {
                cb.limit(rem);
            }
            cr = $this$decode.decode(CharsetJVMKt.EmptyByteBuffer, cb, true);
            cb.flip();
            copied += cb.remaining();
            dst.append(cb);
            v4 = cr;
            Intrinsics.checkNotNullExpressionValue(v4, "cr");
            if (!v4.isUnmappable() && !cr.isMalformed()) continue;
            CharsetJVMKt.throwExceptionWrapped(cr);
        } while (cr.isOverflow());
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeExactBytes(@NotNull CharsetDecoder $this$decodeExactBytes, @NotNull Input input2, int inputLength) {
        Intrinsics.checkNotNullParameter($this$decodeExactBytes, "$this$decodeExactBytes");
        Intrinsics.checkNotNullParameter(input2, "input");
        if (inputLength == 0) {
            return "";
        }
        if (input2 instanceof AbstractInput) {
            AbstractInput this_$iv = (AbstractInput)input2;
            boolean $i$f$getHeadRemaining = false;
            if (this_$iv.getHeadEndExclusive() - this_$iv.getHeadPosition() >= inputLength) {
                if (((AbstractInput)input2).getHeadMemory-SK3TCg8().hasArray()) {
                    void offset$iv;
                    void bytes$iv;
                    ByteBuffer bb2 = ((AbstractInput)input2).getHeadMemory-SK3TCg8();
                    byte[] byArray = bb2.array();
                    Intrinsics.checkNotNullExpressionValue(byArray, "bb.array()");
                    byte[] byArray2 = byArray;
                    int n = bb2.arrayOffset() + bb2.position() + ((AbstractInput)input2).getHead().getReadPosition();
                    Charset charset = $this$decodeExactBytes.charset();
                    Intrinsics.checkNotNullExpressionValue(charset, "charset()");
                    Charset charset$iv = charset;
                    boolean $i$f$String = false;
                    String text = new String((byte[])bytes$iv, (int)offset$iv, inputLength, charset$iv);
                    ((AbstractInput)input2).discardExact(inputLength);
                    return text;
                }
                return CharsetJVMKt.decodeImplByteBuffer($this$decodeExactBytes, (AbstractInput)input2, inputLength);
            }
        }
        return CharsetJVMKt.decodeImplSlow($this$decodeExactBytes, input2, inputLength);
    }

    private static final String decodeImplByteBuffer(CharsetDecoder $this$decodeImplByteBuffer, AbstractInput input2, int inputLength) {
        CoderResult rc2;
        CharBuffer cb = CharBuffer.allocate(inputLength);
        ByteBuffer bb2 = Memory.slice-SK3TCg8(input2.getHeadMemory-SK3TCg8(), input2.getHead().getReadPosition(), inputLength);
        CoderResult coderResult = rc2 = $this$decodeImplByteBuffer.decode(bb2, cb, true);
        Intrinsics.checkNotNullExpressionValue(coderResult, "rc");
        if (coderResult.isMalformed() || rc2.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(rc2);
        }
        cb.flip();
        input2.discardExact(bb2.position());
        String string = cb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "cb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final String decodeImplSlow(CharsetDecoder $this$decodeImplSlow, Input input, int inputLength) {
        block24: {
            block25: {
                cb = CharBuffer.allocate(inputLength);
                remainingInputBytes = inputLength;
                lastChunk = false;
                readSize = 1;
                $this$takeWhileSize$iv = input;
                initialSize$iv = 1;
                $i$f$takeWhileSize = false;
                release$iv = true;
                v0 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize$iv, initialSize$iv);
                if (v0 != null) break block25;
                break block24;
            }
            current$iv = v0;
            size$iv = initialSize$iv;
            try {
                do {
                    block27: {
                        block26: {
                            this_$iv$iv = current$iv;
                            $i$f$getReadRemaining = false;
                            before$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                            after$iv = 0;
                            if (before$iv >= size$iv) {
                                try {
                                    buffer = current$iv;
                                    $i$a$-takeWhileSize-CharsetJVMKt$decodeImplSlow$1 = false;
                                    if (!cb.hasRemaining() || remainingInputBytes == 0) {
                                        v1 = 0;
                                    } else {
                                        $this$readDirect$iv = buffer;
                                        $i$f$readDirect = false;
                                        var20_26 = false;
                                        $this$read$iv$iv = $this$readDirect$iv;
                                        $i$f$read = false;
                                        var22_28 = false;
                                        var23_29 = $this$read$iv$iv.getWritePosition();
                                        var24_30 = $this$read$iv$iv.getReadPosition();
                                        memory$iv = $this$read$iv$iv.getMemory-SK3TCg8();
                                        $i$a$-read-IoBufferJVMKt$readDirect$2$iv = false;
                                        bb = nioBuffer$iv = Memory.slice-SK3TCg8(memory$iv, (int)start$iv, (int)(endExclusive$iv - start$iv));
                                        $i$a$-readDirect-CharsetJVMKt$decodeImplSlow$1$1 = false;
                                        limitBefore = bb.limit();
                                        v2 = lastChunk = limitBefore - (positionBefore = bb.position()) >= remainingInputBytes;
                                        if (lastChunk) {
                                            bb.limit(positionBefore + remainingInputBytes);
                                        }
                                        v3 = rc = $this$decodeImplSlow.decode(bb, cb, lastChunk);
                                        Intrinsics.checkNotNullExpressionValue(v3, "rc");
                                        if (v3.isMalformed() || rc.isUnmappable()) {
                                            CharsetJVMKt.throwExceptionWrapped(rc);
                                        }
                                        if (rc.isUnderflow() && bb.hasRemaining()) {
                                            var33_39 = readSize;
                                            readSize = var33_39 + 1;
                                        } else {
                                            readSize = 1;
                                        }
                                        bb.limit(limitBefore);
                                        remainingInputBytes -= bb.position() - positionBefore;
                                        var34_40 = nioBuffer$iv.limit() == endExclusive$iv - start$iv;
                                        var35_41 = false;
                                        var36_42 = false;
                                        if (!var34_40) {
                                            $i$a$-check-IoBufferJVMKt$readDirect$2$1$iv = false;
                                            var36_43 = "Buffer's limit change is not allowed";
                                            throw (Throwable)new IllegalStateException(var36_43.toString());
                                        }
                                        rc$iv$iv = nioBuffer$iv.position();
                                        $this$read$iv$iv.discardExact(rc$iv$iv);
                                        v1 = readSize;
                                    }
                                    size$iv = v1;
                                }
                                finally {
                                    this_$iv$iv = current$iv;
                                    $i$f$getReadRemaining = false;
                                    after$iv = this_$iv$iv.getWritePosition() - this_$iv$iv.getReadPosition();
                                }
                            } else {
                                after$iv = before$iv;
                            }
                            release$iv = false;
                            if (after$iv != 0) break block26;
                            v4 = UnsafeKt.prepareReadNextHead($this$takeWhileSize$iv, current$iv);
                            break block27;
                        }
                        if (after$iv < size$iv) ** GOTO lbl-1000
                        this_$iv$iv = current$iv;
                        $i$f$getEndGap = false;
                        if (this_$iv$iv.getCapacity() - this_$iv$iv.getLimit() < 8) lbl-1000:
                        // 2 sources

                        {
                            UnsafeKt.completeReadHead($this$takeWhileSize$iv, current$iv);
                            v4 = UnsafeKt.prepareReadFirstHead($this$takeWhileSize$iv, size$iv);
                        } else {
                            v4 = next$iv = current$iv;
                        }
                    }
                    if (next$iv == null) {
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($this$takeWhileSize$iv, current$iv);
                }
            }
        }
        if (cb.hasRemaining() && !lastChunk) {
            v5 = rc = $this$decodeImplSlow.decode(CharsetJVMKt.EmptyByteBuffer, cb, true);
            Intrinsics.checkNotNullExpressionValue(v5, "rc");
            if (v5.isMalformed() || rc.isUnmappable()) {
                CharsetJVMKt.throwExceptionWrapped(rc);
            }
        }
        if (remainingInputBytes > 0) {
            throw (Throwable)new EOFException("Not enough bytes available: had only " + (inputLength - remainingInputBytes) + " instead of " + inputLength);
        }
        if (remainingInputBytes < 0) {
            throw (Throwable)new AssertionError((Object)"remainingInputBytes < 0");
        }
        cb.flip();
        v6 = cb.toString();
        Intrinsics.checkNotNullExpressionValue(v6, "cb.toString()");
        return v6;
    }

    private static final void throwExceptionWrapped(CoderResult $this$throwExceptionWrapped) {
        try {
            $this$throwExceptionWrapped.throwException();
        }
        catch (java.nio.charset.MalformedInputException original) {
            String string = original.getMessage();
            if (string == null) {
                string = "Failed to decode bytes";
            }
            Intrinsics.checkNotNullExpressionValue(string, "original.message ?: \"Failed to decode bytes\"");
            throw (Throwable)new MalformedInputException(string);
        }
    }

    static {
        CharBuffer charBuffer = CharBuffer.allocate(0);
        Intrinsics.checkNotNull(charBuffer);
        EmptyCharBuffer = charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        Intrinsics.checkNotNull(byteBuffer);
        EmptyByteBuffer = byteBuffer;
    }
}

