/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "()V", "channelSetOption", "Ljava/lang/reflect/Method;", "datagramSetOption", "serverChannelSetOption", "standardSocketOptions", "", "", "Ljava/lang/reflect/Field;", "setReusePort", "", "channel", "Ljava/nio/channels/DatagramChannel;", "Ljava/nio/channels/ServerSocketChannel;", "Ljava/nio/channels/SocketChannel;", "socketOption", "name", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    private static final Map<String, Field> standardSocketOptions;
    private static final Method channelSetOption;
    private static final Method serverChannelSetOption;
    private static final Method datagramSetOption;
    @NotNull
    public static final SocketOptionsPlatformCapabilities INSTANCE;

    public final void setReusePort(@NotNull SocketChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = channelSetOption;
        Intrinsics.checkNotNull(method);
        method.invoke((Object)channel2, option, true);
    }

    public final void setReusePort(@NotNull ServerSocketChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = serverChannelSetOption;
        Intrinsics.checkNotNull(method);
        method.invoke((Object)channel2, option, true);
    }

    public final void setReusePort(@NotNull DatagramChannel channel2) {
        Intrinsics.checkNotNullParameter(channel2, "channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = datagramSetOption;
        Intrinsics.checkNotNull(method);
        method.invoke((Object)channel2, option, true);
    }

    private final Object socketOption(String name2) {
        Object object = standardSocketOptions.get(name2);
        if (object == null || (object = ((Field)object).get(null)) == null) {
            throw (Throwable)new IOException("Socket option " + name2 + " is not supported");
        }
        return object;
    }

    private SocketOptionsPlatformCapabilities() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Method method;
        int modifiers;
        int n;
        Method method2;
        int n2;
        Method[] methodArray;
        Class<?> socketChannelClass;
        Class<?> socketOptionType;
        Object $this$associateBy$iv;
        boolean bl;
        int n3;
        SocketOptionsPlatformCapabilities socketOptionsPlatformCapabilities;
        INSTANCE = socketOptionsPlatformCapabilities = new SocketOptionsPlatformCapabilities();
        try {
            Map map2;
            Field[] fieldArray = Class.forName("java.net.StandardSocketOptions");
            if (fieldArray != null && (fieldArray = fieldArray.getFields()) != null) {
                void $this$associateByTo$iv$iv;
                void $this$filterTo$iv$iv;
                Field[] $this$filter$iv = fieldArray;
                boolean $i$f$filter = false;
                Field[] fieldArray2 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Field element$iv$iv2 : $this$filterTo$iv$iv) {
                    void it = element$iv$iv2;
                    boolean bl2 = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue(v1, "it");
                    n3 = v1.getModifiers();
                    bl = false;
                    boolean bl3 = false;
                    int modifiers2 = n3;
                    boolean bl4 = false;
                    boolean bl5 = Modifier.isStatic(modifiers2) && Modifier.isFinal(modifiers2) && Modifier.isPublic(modifiers2);
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$associateBy$iv = (List)destination$iv$iv;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    String string;
                    void it;
                    Field element$iv$iv2;
                    element$iv$iv2 = (Field)element$iv$iv;
                    Map map3 = destination$iv$iv2;
                    boolean bl6 = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue(v3, "it");
                    Intrinsics.checkNotNullExpressionValue(v3.getName(), "it.name");
                    map3.put(string, element$iv$iv);
                }
                map2 = destination$iv$iv2;
            } else {
                map2 = MapsKt.emptyMap();
            }
            $this$associateBy$iv = map2;
        }
        catch (Throwable _) {
            $this$associateBy$iv = MapsKt.emptyMap();
        }
        standardSocketOptions = $this$associateBy$iv;
        try {
            Method method3;
            block15: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz2 = socketChannelClass = Class.forName("java.nio.channels.SocketChannel");
                Intrinsics.checkNotNullExpressionValue(clazz2, "socketChannelClass");
                Method[] methodArray2 = clazz2.getMethods();
                Intrinsics.checkNotNullExpressionValue(methodArray2, "socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray2;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int j = 0; j < n2; ++j) {
                    Method element$iv;
                    method2 = element$iv = methodArray[j];
                    boolean bl7 = false;
                    Method method4 = method2;
                    Intrinsics.checkNotNullExpressionValue(method4, "method");
                    n = method4.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl8 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method2.getName(), "setOption") && method2.getParameterTypes().length == 2 && Intrinsics.areEqual(method2.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method2.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method2.getParameterTypes()[1], Object.class))) continue;
                    method3 = element$iv;
                    break block15;
                }
                method3 = null;
            }
            socketOptionType = method3;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        channelSetOption = socketOptionType;
        try {
            Method method5;
            block16: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz3 = socketChannelClass = Class.forName("java.nio.channels.ServerSocketChannel");
                Intrinsics.checkNotNullExpressionValue(clazz3, "socketChannelClass");
                Method[] methodArray3 = clazz3.getMethods();
                Intrinsics.checkNotNullExpressionValue(methodArray3, "socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray3;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int j = 0; j < n2; ++j) {
                    Method element$iv;
                    method2 = element$iv = methodArray[j];
                    boolean bl9 = false;
                    Method method6 = method2;
                    Intrinsics.checkNotNullExpressionValue(method6, "method");
                    n = method6.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl10 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method2.getName(), "setOption") && method2.getParameterTypes().length == 2 && Intrinsics.areEqual(method2.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method2.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method2.getParameterTypes()[1], Object.class))) continue;
                    method5 = element$iv;
                    break block16;
                }
                method5 = null;
            }
            socketOptionType = method5;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        serverChannelSetOption = socketOptionType;
        try {
            Method method7;
            block17: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(clazz);
                socketOptionType = clazz;
                Class<?> clazz4 = socketChannelClass = Class.forName("java.nio.channels.DatagramChannel");
                Intrinsics.checkNotNullExpressionValue(clazz4, "socketChannelClass");
                Method[] methodArray4 = clazz4.getMethods();
                Intrinsics.checkNotNullExpressionValue(methodArray4, "socketChannelClass.methods");
                Method[] $this$firstOrNull$iv = methodArray4;
                boolean $i$f$firstOrNull = false;
                methodArray = $this$firstOrNull$iv;
                n2 = methodArray.length;
                for (int j = 0; j < n2; ++j) {
                    Method element$iv;
                    method2 = element$iv = methodArray[j];
                    boolean bl11 = false;
                    Method method8 = method2;
                    Intrinsics.checkNotNullExpressionValue(method8, "method");
                    n = method8.getModifiers();
                    n3 = 0;
                    bl = false;
                    modifiers = n;
                    boolean bl12 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual(method2.getName(), "setOption") && method2.getParameterTypes().length == 2 && Intrinsics.areEqual(method2.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method2.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method2.getParameterTypes()[1], Object.class))) continue;
                    method7 = element$iv;
                    break block17;
                }
                method7 = null;
            }
            method = method7;
        }
        catch (Throwable _) {
            method = null;
        }
        datagramSetOption = method;
    }
}

