/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.auth;

import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.auth.HttpAuthHeaderKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u000b*\u00020\u000bH\u0002\"\u0016\u0010\u0000\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0003\"\u0016\u0010\u0006\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\"\u0016\u0010\b\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"authSchemePattern", "Lkotlin/text/Regex;", "getAuthSchemePattern$annotations", "()V", "escapeRegex", "getEscapeRegex$annotations", "parameterPattern", "getParameterPattern$annotations", "token68Pattern", "getToken68Pattern$annotations", "valuePatternPart", "", "parseAuthorizationHeader", "Lio/ktor/http/auth/HttpAuthHeader;", "headerValue", "substringAfterMatch", "result", "Lkotlin/text/MatchResult;", "unescapedIfQuoted", "ktor-http"})
public final class HttpAuthHeaderKt {
    private static final String valuePatternPart = "(\"((\\\\.)|[^\\\\\"])*\")|[^\\s,]*";
    private static final Regex token68Pattern;
    private static final Regex authSchemePattern;
    private static final Regex parameterPattern;
    private static final Regex escapeRegex;

    private static /* synthetic */ void getToken68Pattern$annotations() {
    }

    private static /* synthetic */ void getAuthSchemePattern$annotations() {
    }

    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    private static /* synthetic */ void getEscapeRegex$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final HttpAuthHeader parseAuthorizationHeader(@NotNull String headerValue) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(headerValue, "headerValue");
        MatchResult matchResult = Regex.find$default(authSchemePattern, headerValue, 0, 2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult schemeRegion = matchResult;
        String authScheme = schemeRegion.getValue();
        String string = HttpAuthHeaderKt.substringAfterMatch(headerValue, schemeRegion);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String remaining = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
        MatchResult token68 = Regex.find$default(token68Pattern, remaining, 0, 2, null);
        if (token68 != null && StringsKt.isBlank(HttpAuthHeaderKt.substringAfterMatch(remaining, token68))) {
            return new HttpAuthHeader.Single(authScheme, token68.getValue());
        }
        Sequence $this$associateBy$iv = Regex.findAll$default(parameterPattern, remaining, 0, 2, null);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            MatchResult it;
            MatchResult matchResult2 = (MatchResult)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl2 = false;
            MatchGroup matchGroup = it.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            String string3 = matchGroup.getValue();
            it = (MatchResult)element$iv$iv;
            boolean bl3 = false;
            MatchGroup matchGroup2 = it.getGroups().get(2);
            Intrinsics.checkNotNull(matchGroup2);
            String string4 = HttpAuthHeaderKt.unescapedIfQuoted(matchGroup2.getValue());
            map2.put(string3, string4);
        }
        Map parameters2 = destination$iv$iv;
        return new HttpAuthHeader.Parameterized(authScheme, parameters2, null, 4, null);
    }

    private static final String substringAfterMatch(String $this$substringAfterMatch, MatchResult result2) {
        return StringsKt.drop($this$substringAfterMatch, result2.getRange().getLast() + (result2.getRange().isEmpty() ? 0 : 1));
    }

    private static final String unescapedIfQuoted(String $this$unescapedIfQuoted) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)$this$unescapedIfQuoted, '\"', false, 2, null) && StringsKt.endsWith$default((CharSequence)$this$unescapedIfQuoted, '\"', false, 2, null)) {
            CharSequence charSequence = StringsKt.removeSurrounding($this$unescapedIfQuoted, (CharSequence)"\"");
            Regex regex = escapeRegex;
            Function1 function1 = unescapedIfQuoted.1.INSTANCE;
            boolean bl = false;
            string = regex.replace(charSequence, function1);
        } else {
            string = $this$unescapedIfQuoted;
        }
        return string;
    }

    static {
        String string = "[a-zA-Z0-9\\-._~+/]+=*";
        boolean bl = false;
        token68Pattern = new Regex(string);
        string = "\\S+";
        bl = false;
        authSchemePattern = new Regex(string);
        string = "\\s*,?\\s*(" + token68Pattern + ")\\s*=\\s*((\"((\\\\.)|[^\\\\\"])*\")|[^\\s,]*)\\s*,?\\s*";
        bl = false;
        parameterPattern = new Regex(string);
        string = "\\\\.";
        bl = false;
        escapeRegex = new Regex(string);
    }

    public static final /* synthetic */ Regex access$getToken68Pattern$p() {
        return token68Pattern;
    }
}

