/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieDateParser;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0005H\u0002\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lio/ktor/http/CookieDateParser;", "", "()V", "checkFieldNotNull", "", "T", "source", "", "name", "field", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "checkRequirement", "requirement", "", "msg", "Lkotlin/Function0;", "parse", "Lio/ktor/util/date/GMTDate;", "ktor-http"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source2, String name2, T field) {
        if (field == null) {
            throw (Throwable)new InvalidCookieDateException(source2, "Could not find " + name2);
        }
    }

    private final void checkRequirement(String source2, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw (Throwable)new InvalidCookieDateException(source2, msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        StringLexer lexer = new StringLexer(source2);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile(parse.1.INSTANCE);
        while (lexer.getHasRemaining()) {
            String token2;
            if (!lexer.test(parse.2.INSTANCE)) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$capture = this_$iv;
            boolean bl = false;
            $this$capture.acceptWhile(parse.token.1.1.INSTANCE);
            String string = this_$iv.getSource();
            int n = this_$iv.getIndex();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue(string2.substring(start$iv, n), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            CookieUtilsKt.handleToken(builder, token2);
            lexer.acceptWhile(parse.3.INSTANCE);
        }
        Integer n = builder.getYear();
        int n2 = 70;
        Object object = new IntRange(n2, 99);
        boolean bl = false;
        if (n != null && ((IntRange)object).contains(n)) {
            Integer n3 = builder.getYear();
            Intrinsics.checkNotNull(n3);
            builder.setYear(n3 + 1900);
        } else {
            int n4 = 0;
            object = new IntRange(n4, 69);
            bl = false;
            if (n != null && ((IntRange)object).contains(n)) {
                Integer n5 = builder.getYear();
                Intrinsics.checkNotNull(n5);
                builder.setYear(n5 + 2000);
            }
        }
        this.checkFieldNotNull(source2, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source2, "month", builder.getMonth());
        this.checkFieldNotNull(source2, "year", builder.getYear());
        this.checkFieldNotNull(source2, "time", builder.getHours());
        this.checkFieldNotNull(source2, "time", builder.getMinutes());
        this.checkFieldNotNull(source2, "time", builder.getSeconds());
        int n6 = 1;
        IntRange intRange = new IntRange(n6, 31);
        object = builder.getDayOfMonth();
        bl = false;
        this.checkRequirement(source2, object != null && intRange.contains((Integer)object), parse.4.INSTANCE);
        Integer n7 = builder.getYear();
        Intrinsics.checkNotNull(n7);
        this.checkRequirement(source2, n7 >= 1601, parse.5.INSTANCE);
        Integer n8 = builder.getHours();
        Intrinsics.checkNotNull(n8);
        this.checkRequirement(source2, n8 <= 23, parse.6.INSTANCE);
        Integer n9 = builder.getMinutes();
        Intrinsics.checkNotNull(n9);
        this.checkRequirement(source2, n9 <= 59, parse.7.INSTANCE);
        Integer n10 = builder.getSeconds();
        Intrinsics.checkNotNull(n10);
        this.checkRequirement(source2, n10 <= 59, parse.8.INSTANCE);
        return builder.build();
    }
}

