/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.engine.okhttp.UnsupportedFrameTypeException;
import io.ktor.client.features.websocket.WebSocketException;
import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.DefaultWebSocketSession;
import io.ktor.http.cio.websocket.ExperimentalWebSocketExtensionApi;
import io.ktor.http.cio.websocket.Frame;
import io.ktor.http.cio.websocket.FrameCommonKt;
import io.ktor.http.cio.websocket.WebSocketExtension;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010@\u001a\u00020AH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010BJ \u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J \u0010J\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\"\u0010K\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u000101H\u0016J\u0018\u0010O\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010P\u001a\u00020IH\u0016J\u0018\u0010O\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010Q\u001a\u00020RH\u0016J\u0018\u0010S\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010N\u001a\u000201H\u0016J\u0006\u0010T\u001a\u00020AJ\u001a\u0010T\u001a\u00020A2\u0010\u0010U\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0019H\u0016J\b\u0010V\u001a\u00020AH\u0017R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00198VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R$\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010#\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\b\u0012\u0004\u0012\u0002010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R \u00104\u001a\b\u0012\u0004\u0012\u00020\u001105X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b6\u0010\u001c\u001a\u0004\b7\u00108R$\u00109\u001a\u00020*2\u0006\u0010#\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010-\"\u0004\b;\u0010/R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010=\u001a\u00020*2\u0006\u0010#\u001a\u00020*8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010-\"\u0004\b?\u0010/R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006W"}, d2={"Lio/ktor/client/engine/okhttp/OkHttpWebsocketSession;", "Lio/ktor/http/cio/websocket/DefaultWebSocketSession;", "Lokhttp3/WebSocketListener;", "engine", "Lokhttp3/OkHttpClient;", "webSocketFactory", "Lokhttp3/WebSocket$Factory;", "engineRequest", "Lokhttp3/Request;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lokhttp3/OkHttpClient;Lokhttp3/WebSocket$Factory;Lokhttp3/Request;Lkotlin/coroutines/CoroutineContext;)V", "_closeReason", "Lkotlinx/coroutines/CompletableDeferred;", "Lio/ktor/http/cio/websocket/CloseReason;", "_incoming", "Lkotlinx/coroutines/channels/Channel;", "Lio/ktor/http/cio/websocket/Frame;", "closeReason", "Lkotlinx/coroutines/Deferred;", "getCloseReason", "()Lkotlinx/coroutines/Deferred;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "extensions", "", "Lio/ktor/http/cio/websocket/WebSocketExtension;", "getExtensions$annotations", "()V", "getExtensions", "()Ljava/util/List;", "incoming", "Lkotlinx/coroutines/channels/ReceiveChannel;", "getIncoming", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "<anonymous parameter 0>", "", "masking", "getMasking", "()Z", "setMasking", "(Z)V", "", "maxFrameSize", "getMaxFrameSize", "()J", "setMaxFrameSize", "(J)V", "originResponse", "Lokhttp3/Response;", "getOriginResponse$ktor_client_okhttp", "()Lkotlinx/coroutines/CompletableDeferred;", "outgoing", "Lkotlinx/coroutines/channels/SendChannel;", "getOutgoing$annotations", "getOutgoing", "()Lkotlinx/coroutines/channels/SendChannel;", "pingIntervalMillis", "getPingIntervalMillis", "setPingIntervalMillis", "self", "timeoutMillis", "getTimeoutMillis", "setTimeoutMillis", "flush", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClosed", "webSocket", "Lokhttp3/WebSocket;", "code", "", "reason", "", "onClosing", "onFailure", "t", "", "response", "onMessage", "text", "bytes", "Lokio/ByteString;", "onOpen", "start", "negotiatedExtensions", "terminate", "ktor-client-okhttp"})
public final class OkHttpWebsocketSession
extends WebSocketListener
implements DefaultWebSocketSession {
    private final CompletableDeferred<OkHttpWebsocketSession> self;
    @NotNull
    private final CompletableDeferred<Response> originResponse;
    private final Channel<Frame> _incoming;
    private final CompletableDeferred<CloseReason> _closeReason;
    @NotNull
    private final SendChannel<Frame> outgoing;
    private final OkHttpClient engine;
    private final WebSocket.Factory webSocketFactory;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public final CompletableDeferred<Response> getOriginResponse$ktor_client_okhttp() {
        return this.originResponse;
    }

    @Override
    public long getPingIntervalMillis() {
        return this.engine.pingIntervalMillis();
    }

    @Override
    public void setPingIntervalMillis(long $noName_0) {
        throw (Throwable)new WebSocketException("OkHttp doesn't support dynamic ping interval. You could switch it in the engine configuration.");
    }

    @Override
    public long getTimeoutMillis() {
        return this.engine.readTimeoutMillis();
    }

    @Override
    public void setTimeoutMillis(long $noName_0) {
        throw (Throwable)new WebSocketException("Websocket timeout should be configured in OkHttpEngine.");
    }

    @Override
    public boolean getMasking() {
        return true;
    }

    @Override
    public void setMasking(boolean $noName_0) {
        throw (Throwable)new WebSocketException("Masking switch is not supported in OkHttp engine.");
    }

    @Override
    public long getMaxFrameSize() {
        throw (Throwable)new WebSocketException("OkHttp websocket doesn't support max frame size.");
    }

    @Override
    public void setMaxFrameSize(long $noName_0) {
        throw (Throwable)new WebSocketException("Websocket timeout should be configured in OkHttpEngine.");
    }

    @Override
    @NotNull
    public ReceiveChannel<Frame> getIncoming() {
        return this._incoming;
    }

    @Override
    @NotNull
    public Deferred<CloseReason> getCloseReason() {
        return this._closeReason;
    }

    @Override
    public void start(@NotNull List<? extends WebSocketExtension<?>> negotiatedExtensions) {
        Intrinsics.checkNotNullParameter(negotiatedExtensions, "negotiatedExtensions");
        boolean bl = negotiatedExtensions.isEmpty();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Extensions are not supported.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public static /* synthetic */ void getOutgoing$annotations() {
    }

    @Override
    @NotNull
    public SendChannel<Frame> getOutgoing() {
        return this.outgoing;
    }

    @ExperimentalWebSocketExtensionApi
    public static /* synthetic */ void getExtensions$annotations() {
    }

    @Override
    @NotNull
    public List<WebSocketExtension<?>> getExtensions() {
        return CollectionsKt.emptyList();
    }

    @Override
    public void onOpen(@NotNull WebSocket webSocket2, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(response2, "response");
        super.onOpen(webSocket2, response2);
        this.originResponse.complete(response2);
    }

    @Override
    public void onMessage(@NotNull WebSocket webSocket2, @NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        super.onMessage(webSocket2, bytes);
        ChannelsKt.sendBlocking((SendChannel)this._incoming, new Frame.Binary(true, bytes.toByteArray()));
    }

    @Override
    public void onMessage(@NotNull WebSocket webSocket2, @NotNull String text) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(text, "text");
        super.onMessage(webSocket2, text);
        SendChannel sendChannel = this._incoming;
        String string = text;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        ChannelsKt.sendBlocking(sendChannel, new Frame.Text(true, byArray));
    }

    @Override
    public void onClosed(@NotNull WebSocket webSocket2, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(reason, "reason");
        super.onClosed(webSocket2, code, reason);
        this._closeReason.complete(new CloseReason((short)code, reason));
        SendChannel.DefaultImpls.close$default(this._incoming, null, 1, null);
        SendChannel<Frame> sendChannel = this.getOutgoing();
        StringBuilder stringBuilder = new StringBuilder().append("WebSocket session closed with code ");
        Object object = CloseReason.Codes.Companion.byCode((short)code);
        if (object == null || (object = object.toString()) == null) {
            object = code;
        }
        sendChannel.close(new CancellationException(stringBuilder.append(object).append('.').toString()));
    }

    @Override
    public void onClosing(@NotNull WebSocket webSocket2, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(reason, "reason");
        super.onClosing(webSocket2, code, reason);
        this._closeReason.complete(new CloseReason((short)code, reason));
        try {
            ChannelsKt.sendBlocking(this.getOutgoing(), new Frame.Close(new CloseReason((short)code, reason)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SendChannel.DefaultImpls.close$default(this._incoming, null, 1, null);
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket2, @NotNull Throwable t, @Nullable Response response2) {
        Intrinsics.checkNotNullParameter(webSocket2, "webSocket");
        Intrinsics.checkNotNullParameter(t, "t");
        super.onFailure(webSocket2, t, response2);
        this._closeReason.completeExceptionally(t);
        this.originResponse.completeExceptionally(t);
        this._incoming.close(t);
        this.getOutgoing().close(t);
    }

    @Override
    @Nullable
    public Object flush(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    public final void start() {
        this.self.complete(this);
    }

    @Override
    @Deprecated(message="Use cancel() instead.", replaceWith=@ReplaceWith(imports={"kotlinx.coroutines.cancel"}, expression="cancel()"))
    public void terminate() {
        JobKt.cancel$default(this.getCoroutineContext(), null, 1, null);
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public OkHttpWebsocketSession(@NotNull OkHttpClient engine2, @NotNull WebSocket.Factory webSocketFactory, @NotNull Request engineRequest, @NotNull CoroutineContext coroutineContext2) {
        Intrinsics.checkNotNullParameter(engine2, "engine");
        Intrinsics.checkNotNullParameter(webSocketFactory, "webSocketFactory");
        Intrinsics.checkNotNullParameter(engineRequest, "engineRequest");
        Intrinsics.checkNotNullParameter(coroutineContext2, "coroutineContext");
        this.engine = engine2;
        this.webSocketFactory = webSocketFactory;
        this.coroutineContext = coroutineContext2;
        this.self = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        this.originResponse = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        this._incoming = ChannelKt.Channel$default(0, null, null, 7, null);
        this._closeReason = CompletableDeferredKt.CompletableDeferred$default(null, 1, null);
        this.outgoing = ActorKt.actor$default(this, null, 0, null, null, new Function2<ActorScope<Frame>, Continuation<? super Unit>, Object>(this, engineRequest, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ OkHttpWebsocketSession this$0;
            final /* synthetic */ Request $engineRequest;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$actor = (ActorScope)this.L$0;
                        var10_4 = this.$engineRequest;
                        var9_5 = OkHttpWebsocketSession.access$getWebSocketFactory$p(this.this$0);
                        this.L$0 = $this$actor;
                        this.L$1 = var9_5;
                        this.L$2 = var10_4;
                        this.label = 1;
                        v0 = OkHttpWebsocketSession.access$getSelf$p(this.this$0).await(this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        var10_4 = (Request)this.L$2;
                        var9_5 = (WebSocket.Factory)this.L$1;
                        $this$actor = (ActorScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        var11_6 = v0;
                        websocket = var9_5.newWebSocket(var10_4, (WebSocketListener)var11_6);
                        try {
                            var5_8 = $this$actor.getChannel().iterator();
                        }
                        catch (Throwable var4_10) {
                            websocket.close(CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                            throw var4_10;
                        }
lbl32:
                        // 3 sources

                        while (true) {
                            this.L$0 = websocket;
                            this.L$1 = var5_8;
                            this.L$2 = null;
                            this.label = 2;
                            v1 = var5_8.hasNext(this);
                            if (v1 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl47
                            break;
                        }
                    }
                    case 2: {
                        var5_8 = (ChannelIterator<E>)this.L$1;
                        websocket = (WebSocket)this.L$0;
                        {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl47:
                            // 2 sources

                            if (!((Boolean)v1).booleanValue()) ** GOTO lbl71
                            frame = (Frame)var5_8.next();
                            var6_11 = frame;
                            if (!(var6_11 instanceof Frame.Binary)) ** GOTO lbl54
                            websocket.send(ByteString.Companion.of(frame.getData(), 0, frame.getData().length));
                            ** GOTO lbl32
lbl54:
                            // 1 sources

                            if (var6_11 instanceof Frame.Text) {
                                var7_12 = frame.getData();
                                var8_13 = false;
                                websocket.send(new String(var7_12, Charsets.UTF_8));
                                ** continue;
                            }
                            if (!(var6_11 instanceof Frame.Close)) ** GOTO lbl-1000
                            v2 = FrameCommonKt.readReason((Frame.Close)frame);
                            Intrinsics.checkNotNull(v2);
                            reason = v2;
                            websocket.close(reason.getCode(), reason.getMessage());
                            var8_14 = Unit.INSTANCE;
                            websocket.close(CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                        }
                        return var8_14;
lbl-1000:
                        // 1 sources

                        {
                            throw (Throwable)new UnsupportedFrameTypeException(frame);
                        }
lbl71:
                        // 1 sources

                        websocket.close(CloseReason.Codes.INTERNAL_ERROR.getCode(), "Client failure");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = okHttpWebsocketSession;
                this.$engineRequest = request2;
                super(2, continuation2);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, "completion");
                Function2<ActorScope<Frame>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 15, null);
    }

    @Override
    @Nullable
    public Object send(@NotNull Frame frame, @NotNull Continuation<? super Unit> continuation2) {
        return DefaultWebSocketSession.DefaultImpls.send(this, frame, continuation2);
    }

    public static final /* synthetic */ WebSocket.Factory access$getWebSocketFactory$p(OkHttpWebsocketSession $this) {
        return $this.webSocketFactory;
    }

    public static final /* synthetic */ CompletableDeferred access$getSelf$p(OkHttpWebsocketSession $this) {
        return $this.self;
    }
}

