/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.internal.data;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import net.mamoe.mirai.console.MiraiConsole;
import net.mamoe.mirai.console.data.AbstractPluginData;
import net.mamoe.mirai.console.data.MultiFilePluginDataStorage;
import net.mamoe.mirai.console.data.PluginData;
import net.mamoe.mirai.console.data.PluginDataHolder;
import net.mamoe.mirai.console.data.PluginDataStorage;
import net.mamoe.mirai.console.internal.data.MultiFilePluginDataStorageImpl;
import net.mamoe.mirai.console.internal.data.MultiFilePluginDataStorageImplKt;
import net.mamoe.mirai.console.internal.data.ReflectionUtilsKt;
import net.mamoe.mirai.console.util.ConsoleExperimentalApi;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.SilentLogger;
import net.mamoe.yamlkt.Yaml;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/mamoe/mirai/console/internal/data/MultiFilePluginDataStorageImpl;", "Lnet/mamoe/mirai/console/data/PluginDataStorage;", "Lnet/mamoe/mirai/console/data/MultiFilePluginDataStorage;", "directoryPath", "Ljava/nio/file/Path;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "(Ljava/nio/file/Path;Lnet/mamoe/mirai/utils/MiraiLogger;)V", "getDirectoryPath", "()Ljava/nio/file/Path;", "json", "Lkotlinx/serialization/json/Json;", "yaml", "Lnet/mamoe/yamlkt/Yaml$Default;", "getPluginDataFile", "Ljava/io/File;", "holder", "Lnet/mamoe/mirai/console/data/PluginDataHolder;", "instance", "Lnet/mamoe/mirai/console/data/PluginData;", "load", "", "store", "mirai-console"})
public class MultiFilePluginDataStorageImpl
implements PluginDataStorage,
MultiFilePluginDataStorage {
    @NotNull
    private final Path directoryPath;
    @NotNull
    private final MiraiLogger logger;
    @NotNull
    private final Json json;
    @NotNull
    private final Yaml.Default yaml;

    public MultiFilePluginDataStorageImpl(@NotNull Path directoryPath, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.directoryPath = directoryPath;
        this.logger = logger2;
        MultiFilePluginDataStorageImplKt.mkdir(this.directoryPath);
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.yaml = Yaml.Default;
    }

    public /* synthetic */ MultiFilePluginDataStorageImpl(Path path, MiraiLogger miraiLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miraiLogger = (MiraiLogger)SilentLogger.INSTANCE;
        }
        this(path, miraiLogger);
    }

    @Override
    @NotNull
    public final Path getDirectoryPath() {
        return this.directoryPath;
    }

    @Override
    public void load(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        String string;
        MiraiLogger miraiLogger;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        instance2.onInit(holder, this);
        String text = FilesKt.readText$default((File)this.getPluginDataFile(holder, instance2), null, (int)1, null);
        CharSequence charSequence = text;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            MiraiLogger $this$warning$iv = this.logger;
            boolean $i$f$warning = false;
            if ($this$warning$iv.isEnabled()) {
                miraiLogger = $this$warning$iv;
                boolean bl2 = false;
                string = Intrinsics.stringPlus((String)"Deserializing ", (Object)text);
                miraiLogger.warning(string);
            }
            Yaml.Default.decodeFromString((DeserializationStrategy)instance2.getUpdaterSerializer(), text);
        } else {
            this.store(holder, instance2);
        }
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            List<AbstractPluginData.ValueNode<?>> list;
            AbstractPluginData abstractPluginData;
            miraiLogger = $this$debug$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Successfully loaded PluginData: ").append(instance2.getSaveName()).append(" (containing ");
            PluginData $this$castOrNull$iv = instance2;
            boolean $i$f$castOrNull = false;
            boolean bl4 = false;
            PluginData pluginData = $this$castOrNull$iv;
            if (!(pluginData instanceof AbstractPluginData)) {
                pluginData = null;
            }
            string = stringBuilder.append((abstractPluginData = (AbstractPluginData)pluginData) == null ? null : ((list = abstractPluginData.getValueNodes()) == null ? null : Integer.valueOf(list.size()))).append(" properties)").toString();
            miraiLogger.debug(string);
        }
    }

    @NotNull
    protected File getPluginDataFile(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        String name = instance2.getSaveName();
        Path dir = this.directoryPath.resolve(holder.getDataHolderName());
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        if (MultiFilePluginDataStorageImplKt.isFile(dir)) {
            String string = "Target directory " + dir + " for holder " + holder + " is occupied by a file therefore data " + ReflectionUtilsKt.getQualifiedNameOrTip(Reflection.getOrCreateKotlinClass(instance2.getClass())) + " can't be saved.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        MultiFilePluginDataStorageImplKt.mkdir(dir);
        Path file = dir.resolve(Intrinsics.stringPlus((String)name, (Object)".yml"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        if (MultiFilePluginDataStorageImplKt.isDirectory(file)) {
            String string = "Target File " + file + " is occupied by a directory therefore data " + ReflectionUtilsKt.getQualifiedNameOrTip(Reflection.getOrCreateKotlinClass(instance2.getClass())) + " can't be saved.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$debug$iv;
            boolean bl = false;
            String string = "File allocated for " + instance2.getSaveName() + ": " + file;
            miraiLogger.debug(string);
        }
        File file2 = file.toFile();
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        it.createNewFile();
        File file3 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"file.toFile().also { it.createNewFile() }");
        return file3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ConsoleExperimentalApi
    public void store(@NotNull PluginDataHolder holder, @NotNull PluginData instance2) {
        Object object;
        Object object2;
        Object object3;
        Object $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422;
        boolean bl;
        boolean bl2;
        Object object4;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)instance2, (String)"instance");
        File file = this.getPluginDataFile(holder, instance2);
        boolean bl3 = false;
        try {
            object4 = Result.Companion;
            boolean $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 = false;
            String string = this.yaml.encodeToString((SerializationStrategy)instance2.getUpdaterSerializer(), (Object)Unit.INSTANCE);
            bl2 = false;
            bl = false;
            String it = string;
            boolean bl4 = false;
            this.yaml.decodeAnyFromString(it);
            $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 = string;
            boolean bl5 = false;
            object4 = Result.constructor-impl((Object)$i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422);
        }
        catch (Throwable $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422) {
            Result.Companion companion = Result.Companion;
            bl2 = false;
            object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422));
        }
        Object object5 = object3 = object4;
        boolean bl6 = false;
        $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 = Result.exceptionOrNull-impl((Object)object5);
        if ($i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 == null) {
            object2 = object5;
        } else {
            Object object6;
            Object object7 = object5;
            bl2 = false;
            try {
                object6 = Result.Companion;
                object = object7;
                boolean bl7 = false;
                Object it = $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422;
                boolean bl8 = false;
                MiraiConsole.INSTANCE.getMainLogger().warning("Could not save " + instance2.getSaveName() + " in YAML format due to exception in YAML encoder. Please report this exception and relevant configurations to https://github.com/mamoe/mirai-console/issues/new", (Throwable)it);
                object = this.json.encodeToString((SerializationStrategy)instance2.getUpdaterSerializer(), (Object)Unit.INSTANCE);
                bl7 = false;
                object6 = Result.constructor-impl((Object)object);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl9 = false;
                object6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object6;
        }
        object3 = object2;
        File file2 = file;
        object5 = object3;
        bl6 = false;
        boolean $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 = false;
        Throwable $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 = Result.exceptionOrNull-impl((Object)object5);
        if ($i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422 != null) {
            void it;
            Throwable throwable = $i$a$-runCatching-MultiFilePluginDataStorageImpl$store$422;
            file = file2;
            boolean bl10 = false;
            throw new IllegalStateException("Exception while saving " + instance2 + ", saveName=" + instance2.getSaveName(), (Throwable)it);
        }
        FilesKt.writeText$default((File)file2, (String)((String)object5), null, (int)2, null);
        MiraiLogger $this$debug$iv = this.logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isEnabled()) {
            List<AbstractPluginData.ValueNode<?>> list;
            file = $this$debug$iv;
            boolean bl11 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Successfully saved PluginData: ").append(instance2.getSaveName()).append(" (containing ");
            PluginData $this$castOrNull$iv = instance2;
            boolean $i$f$castOrNull = false;
            bl = false;
            PluginData pluginData = $this$castOrNull$iv;
            if (!(pluginData instanceof AbstractPluginData)) {
                pluginData = null;
            }
            object3 = stringBuilder.append((object = (AbstractPluginData)pluginData) == null ? null : ((list = ((AbstractPluginData)object).getValueNodes()) == null ? null : Integer.valueOf(list.size()))).append(" properties)").toString();
            file.debug((String)object3);
        }
    }
}

