/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.plugin.description;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.mamoe.mirai.console.compiler.common.CheckerConstants;
import net.mamoe.mirai.console.compiler.common.ResolveContext;
import net.mamoe.mirai.console.plugin.description.IllegalPluginDescriptionException;
import net.mamoe.mirai.console.plugin.description.PluginDependency;
import net.mamoe.mirai.console.util.SemVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u0005R\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005R\u001a\u0010\u0011\u001a\u00020\u00038&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0005R\u001a\u0010\u0014\u001a\u00020\u00158&X\u00a7\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\r\u001a\u0004\b\u0017\u0010\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lnet/mamoe/mirai/console/plugin/description/PluginDescription;", "", "author", "", "getAuthor", "()Ljava/lang/String;", "dependencies", "", "Lnet/mamoe/mirai/console/plugin/description/PluginDependency;", "getDependencies", "()Ljava/util/Set;", "id", "getId$annotations", "()V", "getId", "info", "getInfo", "name", "getName$annotations", "getName", "version", "Lnet/mamoe/mirai/console/util/SemVersion;", "getVersion$annotations", "getVersion", "()Lnet/mamoe/mirai/console/util/SemVersion;", "Companion", "mirai-console"})
public interface PluginDescription {
    @NotNull
    public static final Companion Companion = net.mamoe.mirai.console.plugin.description.PluginDescription$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @ResolveContext(kinds={ResolveContext.Kind.PLUGIN_ID})
    public static /* synthetic */ void getId$annotations() {
    }

    @NotNull
    public String getName();

    @ResolveContext(kinds={ResolveContext.Kind.PLUGIN_NAME})
    public static /* synthetic */ void getName$annotations() {
    }

    @NotNull
    public String getAuthor();

    @NotNull
    public SemVersion getVersion();

    @ResolveContext(kinds={ResolveContext.Kind.SEMANTIC_VERSION})
    public static /* synthetic */ void getVersion$annotations() {
    }

    @NotNull
    public String getInfo();

    @NotNull
    public Set<PluginDependency> getDependencies();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0005R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lnet/mamoe/mirai/console/plugin/description/PluginDescription$Companion;", "", "()V", "FORBIDDEN_ID_NAMES", "", "", "getFORBIDDEN_ID_NAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ID_REGEX", "Lkotlin/text/Regex;", "getID_REGEX", "()Lkotlin/text/Regex;", "checkDependencies", "", "pluginId", "dependencies", "", "Lnet/mamoe/mirai/console/plugin/description/PluginDependency;", "checkPluginDescription", "instance", "Lnet/mamoe/mirai/console/plugin/description/PluginDescription;", "checkPluginId", "id", "checkPluginName", "name", "mirai-console"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Regex ID_REGEX;
        @NotNull
        private static final String[] FORBIDDEN_ID_NAMES;

        private Companion() {
        }

        @NotNull
        public final Regex getID_REGEX() {
            return ID_REGEX;
        }

        @NotNull
        public final String[] getFORBIDDEN_ID_NAMES() {
            return FORBIDDEN_ID_NAMES;
        }

        public final void checkPluginDescription(@NotNull PluginDescription instance2) throws IllegalPluginDescriptionException {
            Object object;
            Intrinsics.checkNotNullParameter(instance2, "instance");
            boolean bl = false;
            try {
                object = Result.Companion;
                boolean bl2 = false;
                $$INSTANCE.checkPluginId(instance2.getId());
                $$INSTANCE.checkPluginName(instance2.getName());
                $$INSTANCE.checkDependencies(instance2.getId(), instance2.getDependencies());
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl(unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl7 = false;
                throw new IllegalPluginDescriptionException("Illegal PluginDescription. Plugin " + instance2.getName() + " (" + instance2.getId() + ')', it);
            }
        }

        public final void checkPluginId(@NotNull String id) throws IllegalPluginDescriptionException {
            String string;
            int n;
            block7: {
                String string2;
                boolean bl;
                int n2;
                int it;
                block6: {
                    Intrinsics.checkNotNullParameter(id, "id");
                    if (StringsKt.isBlank(id)) {
                        throw new IllegalPluginDescriptionException("Plugin id cannot be blank");
                    }
                    CharSequence $this$none$iv = id;
                    boolean $i$f$none = false;
                    CharSequence charSequence = $this$none$iv;
                    for (n = 0; n < charSequence.length(); ++n) {
                        int element$iv;
                        it = element$iv = charSequence.charAt(n);
                        n2 = 0;
                        if (!(it == 46)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (bl) {
                    throw new IllegalPluginDescriptionException('\'' + id + "' is illegal. Plugin id must consist of both domain and name. ");
                }
                string = id;
                boolean bl2 = false;
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                String lowercaseId = string3;
                if (ID_REGEX.matchEntire(id) == null) {
                    throw new IllegalPluginDescriptionException("Plugin does not match regex '" + ID_REGEX.getPattern() + "'.");
                }
                String[] $this$firstOrNull$iv = FORBIDDEN_ID_NAMES;
                boolean $i$f$firstOrNull = false;
                String[] stringArray = $this$firstOrNull$iv;
                it = stringArray.length;
                for (n2 = 0; n2 < it; ++n2) {
                    String element$iv;
                    String it2 = element$iv = stringArray[n2];
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it2, lowercaseId)) continue;
                    string2 = element$iv;
                    break block7;
                }
                string2 = string = null;
            }
            if (string != null) {
                String string4 = string;
                n = 0;
                boolean bl = false;
                String illegal = string4;
                boolean bl4 = false;
                throw new IllegalPluginDescriptionException("Plugin id contains illegal word: '" + illegal + "'.");
            }
        }

        public final void checkPluginName(@NotNull String name) throws IllegalPluginDescriptionException {
            String string;
            block3: {
                String string2;
                Intrinsics.checkNotNullParameter(name, "name");
                if (StringsKt.isBlank(name)) {
                    throw new IllegalPluginDescriptionException("Plugin name cannot be blank");
                }
                string = name;
                boolean bl = false;
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                String lowercaseName = string3;
                String[] $this$firstOrNull$iv = FORBIDDEN_ID_NAMES;
                boolean $i$f$firstOrNull = false;
                String[] stringArray = $this$firstOrNull$iv;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = stringArray[i];
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it, lowercaseName)) continue;
                    string2 = element$iv;
                    break block3;
                }
                string2 = string = null;
            }
            if (string != null) {
                String string4 = string;
                boolean bl = false;
                boolean bl3 = false;
                String illegal = string4;
                boolean bl4 = false;
                throw new IllegalPluginDescriptionException("Plugin name is illegal: '" + illegal + "'.");
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void checkDependencies(@NotNull String pluginId, @NotNull Set<PluginDependency> dependencies) throws IllegalPluginDescriptionException {
            boolean bl;
            block7: {
                void $this$mapTo$iv;
                Intrinsics.checkNotNullParameter(pluginId, "pluginId");
                Intrinsics.checkNotNullParameter(dependencies, "dependencies");
                String string = pluginId;
                boolean bl2 = false;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                String lowercaseId = string2;
                Iterable iterable = dependencies;
                Collection destination$iv = new LinkedHashSet(dependencies.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    String string3;
                    void it;
                    PluginDependency pluginDependency = (PluginDependency)item$iv;
                    Collection collection = destination$iv;
                    boolean bl3 = false;
                    String string4 = it.getId();
                    boolean bl4 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue(string5.toLowerCase(Locale.ROOT), "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    collection.add(string3);
                }
                LinkedHashSet lowercaseDependencies = (LinkedHashSet)destination$iv;
                if (lowercaseDependencies.size() != dependencies.size()) {
                    throw new IllegalPluginDescriptionException("Duplicated dependency detected: A plugin cannot depend on different versions of dependencies of the same id");
                }
                Iterable $this$any$iv = lowercaseDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual(it, lowercaseId)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalPluginDescriptionException("Recursive dependency detected: A plugin cannot depend on itself");
            }
        }

        static {
            $$INSTANCE = new Companion();
            ID_REGEX = CheckerConstants.PLUGIN_ID_REGEX;
            FORBIDDEN_ID_NAMES = CheckerConstants.PLUGIN_FORBIDDEN_NAMES;
        }
    }
}

