/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.caller;

import io.github.karlatemp.caller.CallerImplement;
import io.github.karlatemp.caller.ReflectionHelper;
import io.github.karlatemp.caller.StackFrame;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CallerThreadTrace
implements CallerImplement {
    private static final Function<Object, StackTraceElement> MF_STE = v -> (StackTraceElement)v;
    private static final Function<StackTraceElement, StackFrame> FWX = trace -> new StackFrame(trace.getClassName(), null, trace.getFileName(), trace.getMethodName(), trace.getLineNumber(), -1, trace.isNativeMethod(), null, null, trace, MF_STE);

    CallerThreadTrace() {
    }

    @Override
    public StackFrame getCaller() {
        return (StackFrame)this.process(1, true);
    }

    @Override
    public StackFrame getCaller(int frame) {
        return (StackFrame)this.process(frame, true);
    }

    @Override
    public List<StackFrame> getTrack() {
        return (List)this.process(0, false);
    }

    private Object process(int frame, boolean unique) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Stream<StackTraceElement> stream = Stream.of(stackTrace).filter(trace -> ReflectionHelper.isNotReflectionClass(trace.getClassName())).skip(4 + frame);
        if (unique) {
            return stream.findFirst().map(FWX).orElse(null);
        }
        return stream.map(FWX).collect(Collectors.toList());
    }
}

