/*
 * Decompiled with CFR 0.152.
 */
package org.jline.console;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jline.console.CmdDesc;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.terminal.Terminal;

public interface CommandRegistry {
    public static SystemCompleter aggregateCompleters(CommandRegistry ... commandRegistries) {
        SystemCompleter out = new SystemCompleter();
        for (CommandRegistry r : commandRegistries) {
            out.add(r.compileCompleters());
        }
        return out;
    }

    public static SystemCompleter compileCompleters(CommandRegistry ... commandRegistries) {
        SystemCompleter out = CommandRegistry.aggregateCompleters(commandRegistries);
        out.compile();
        return out;
    }

    default public String name() {
        return this.getClass().getSimpleName();
    }

    public Set<String> commandNames();

    public Map<String, String> commandAliases();

    public List<String> commandInfo(String var1);

    public boolean hasCommand(String var1);

    public SystemCompleter compileCompleters();

    default public CmdDesc commandDescription(List<String> args) {
        return !args.isEmpty() ? this.commandDescription(args.get(0)) : this.commandDescription("");
    }

    public CmdDesc commandDescription(String var1);

    default public Object execute(CommandSession session, String command, String[] args) throws Exception {
        throw new IllegalArgumentException("CommandRegistry method execute(String command, String[] args) is not implemented!");
    }

    default public Object invoke(CommandSession session, String command, Object ... args) throws Exception {
        String[] _args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException();
            }
            _args[i] = args[i].toString();
        }
        return this.execute(session, command, _args);
    }

    public static class CommandSession {
        private final Terminal terminal;
        private final InputStream in;
        private final PrintStream out;
        private final PrintStream err;

        public CommandSession() {
            this.in = System.in;
            this.out = System.out;
            this.err = System.err;
            this.terminal = null;
        }

        public CommandSession(Terminal terminal2) {
            this(terminal2, terminal2.input(), new PrintStream(terminal2.output()), new PrintStream(terminal2.output()));
        }

        public CommandSession(Terminal terminal2, InputStream in, PrintStream out, PrintStream err) {
            this.terminal = terminal2;
            this.in = in;
            this.out = out;
            this.err = err;
        }

        public Terminal terminal() {
            return this.terminal;
        }

        public InputStream in() {
            return this.in;
        }

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }
    }
}

