/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.terminal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.console.fontend.ProcessProgress;
import net.mamoe.mirai.console.terminal.TerminalProcessProgressKt;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\"R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0013j\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/mamoe/mirai/console/terminal/TerminalProcessProgress;", "Lnet/mamoe/mirai/console/fontend/ProcessProgress;", "reader", "Lorg/jline/reader/LineReader;", "(Lorg/jline/reader/LineReader;)V", "ansiMsg", "Lorg/jline/utils/AttributedString;", "disposed", "", "eraseTimestamp", "", "failed", "lastTerminalWidth", "", "needRerender", "needUpdateTxt", "pendingErase", "processed", "renderedTxt", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "totalSize", "txt", "close", "", "markFailed", "rerender", "setTotalSize", "update", "updateText", "", "", "updateTxt", "terminalWidth", "updateTxt$mirai_console_terminal", "mirai-console-terminal"})
public final class TerminalProcessProgress
implements ProcessProgress {
    @NotNull
    private final LineReader reader;
    private long totalSize;
    private long processed;
    @NotNull
    private final StringBuilder txt;
    @NotNull
    private final StringBuilder renderedTxt;
    private boolean failed;
    private boolean disposed;
    @JvmField
    public boolean pendingErase;
    @JvmField
    public long eraseTimestamp;
    @JvmField
    @NotNull
    public AttributedString ansiMsg;
    private int lastTerminalWidth;
    private boolean needRerender;
    private boolean needUpdateTxt;

    public TerminalProcessProgress(@NotNull LineReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        this.totalSize = 1L;
        this.txt = new StringBuilder();
        this.renderedTxt = new StringBuilder();
        AttributedString attributedString = AttributedString.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)attributedString, (String)"EMPTY");
        this.ansiMsg = attributedString;
        this.needRerender = true;
        this.needUpdateTxt = true;
    }

    public void updateText(@NotNull CharSequence txt) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        this.txt.setLength(0);
        this.txt.append(txt);
        this.needUpdateTxt = true;
        this.needRerender = true;
    }

    public void updateText(@NotNull String txt) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        this.updateText((CharSequence)txt);
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
        this.needRerender = true;
    }

    public void update(long processed) {
        this.processed = processed;
        this.needRerender = true;
    }

    public void update(long processed, long totalSize) {
        this.processed = processed;
        this.totalSize = totalSize;
        this.needRerender = true;
    }

    public void markFailed() {
        this.failed = true;
        this.needRerender = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTxt$mirai_console_terminal(int terminalWidth) {
        if (this.needUpdateTxt || this.lastTerminalWidth != terminalWidth) {
            this.lastTerminalWidth = terminalWidth;
            StringBuilder stringBuilder = this.renderedTxt;
            synchronized (stringBuilder) {
                boolean $i$a$-synchronized-TerminalProcessProgress$updateTxt$22 = false;
                this.renderedTxt.setLength(0);
                this.renderedTxt.append((CharSequence)this.txt);
                if (this.renderedTxt.length() < terminalWidth) {
                    int n = terminalWidth - this.renderedTxt.length();
                    int n2 = 0;
                    while (n2 < n) {
                        int it = n2++;
                        boolean bl = false;
                        this.renderedTxt.append(' ');
                    }
                }
                Unit $i$a$-synchronized-TerminalProcessProgress$updateTxt$22 = Unit.INSTANCE;
            }
        } else if (!this.needRerender) {
            return;
        }
        this.lastTerminalWidth = terminalWidth;
        int renderedTextWidth = terminalWidth == 0 ? this.renderedTxt.length() : terminalWidth;
        AttributedStringBuilder finalAnsiLineBuilder = new AttributedStringBuilder();
        if (this.failed) {
            finalAnsiLineBuilder.style(AttributedStyle.DEFAULT.background(1).foreground(0));
            finalAnsiLineBuilder.append((CharSequence)this.renderedTxt, 0, renderedTextWidth);
        } else {
            int downpcent = (int)((long)renderedTextWidth * this.processed / this.totalSize);
            if (downpcent > 0) {
                finalAnsiLineBuilder.style(AttributedStyle.DEFAULT.background(2).foreground(0));
                finalAnsiLineBuilder.append((CharSequence)this.renderedTxt, 0, downpcent);
            }
            if (downpcent < renderedTextWidth) {
                finalAnsiLineBuilder.style(AttributedStyle.DEFAULT.background(7).foreground(0));
                finalAnsiLineBuilder.append((CharSequence)this.renderedTxt, downpcent, renderedTextWidth);
            }
        }
        AttributedString attributedString = finalAnsiLineBuilder.toAttributedString();
        Intrinsics.checkNotNullExpressionValue((Object)attributedString, (String)"finalAnsiLineBuilder.toAttributedString()");
        this.ansiMsg = attributedString;
        this.needUpdateTxt = false;
        this.needRerender = false;
    }

    public void rerender() {
        TerminalProcessProgressKt.updateTerminalDownloadingProgresses();
    }

    public void close() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.totalSize = 1L;
        this.processed = 1L;
        this.needUpdateTxt = true;
        this.updateTxt$mirai_console_terminal(this.reader.getTerminal().getWidth());
        if (this.failed) {
            TerminalProcessProgressKt.getTerminalDownloadingProgresses().remove(this);
            TerminalProcessProgressKt.printToScreen(this.ansiMsg);
            AttributedString attributedString = AttributedString.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)attributedString, (String)"EMPTY");
            this.ansiMsg = attributedString;
            return;
        }
        this.pendingErase = true;
        this.eraseTimestamp = System.currentTimeMillis() + 1500L;
        TerminalProcessProgressKt.updateTerminalDownloadingProgresses();
    }
}

