/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.console.terminal;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import net.mamoe.mirai.console.terminal.LoggingService;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0015\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eR\u001e\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/mamoe/mirai/console/terminal/LoggingServiceI;", "Lnet/mamoe/mirai/console/terminal/LoggingService;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "autoSplitTask", "Ljava/util/concurrent/Future;", "getAutoSplitTask$mirai_console_terminal", "()Ljava/util/concurrent/Future;", "setAutoSplitTask$mirai_console_terminal", "(Ljava/util/concurrent/Future;)V", "pipeline", "Lkotlinx/coroutines/channels/Channel;", "", "pipelineSize", "", "getPipelineSize$mirai_console_terminal", "()I", "threadDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "threadPool", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "pushInPool", "", "line", "pushLine", "pushLine$mirai_console_terminal", "startup", "logDir", "Ljava/io/File;", "mirai-console-terminal"})
public final class LoggingServiceI
extends LoggingService {
    @NotNull
    private final CoroutineScope scope;
    private final ScheduledExecutorService threadPool;
    @NotNull
    private final ExecutorCoroutineDispatcher threadDispatcher;
    private final int pipelineSize;
    @NotNull
    private final Channel<String> pipeline;
    public Future<?> autoSplitTask;

    public LoggingServiceI(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(null);
        this.scope = scope;
        ScheduledExecutorService scheduledExecutorService = this.threadPool = Executors.newScheduledThreadPool(3, new ThreadFactory(){
            @NotNull
            private final ThreadGroup group;
            @NotNull
            private final AtomicInteger counter;
            {
                this.group = new ThreadGroup("mirai console terminal logging");
                this.counter = new AtomicInteger(0);
            }

            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                Thread thread;
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Thread thread2 = thread = new Thread(this.group, r, "Mirai Console Terminal Logging Thread#" + this.counter.getAndIncrement());
                boolean bl = false;
                thread2.setDaemon(true);
                return thread;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"threadPool");
        this.threadDispatcher = ExecutorsKt.from((ExecutorService)scheduledExecutorService);
        this.pipelineSize = (int)MiraiUtils.systemProp((String)"mirai.console.terminal.log.buffer", (long)2048L);
        this.pipeline = ChannelKt.Channel$default((int)this.pipelineSize, null, null, (int)6, null);
    }

    public final int getPipelineSize$mirai_console_terminal() {
        return this.pipelineSize;
    }

    @NotNull
    public final Future<?> getAutoSplitTask$mirai_console_terminal() {
        Future<?> future = this.autoSplitTask;
        if (future != null) {
            return future;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"autoSplitTask");
        return null;
    }

    public final void setAutoSplitTask$mirai_console_terminal(@NotNull Future<?> future) {
        Intrinsics.checkNotNullParameter(future, (String)"<set-?>");
        this.autoSplitTask = future;
    }

    public final void startup(@NotNull File logDir) {
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        logDir.mkdirs();
        Object outputLock = new Object();
        AtomicReference<RandomAccessFile> output = new AtomicReference<RandomAccessFile>();
        LoggingServiceI.startup$switchLogFile(logDir, outputLock, output);
        this.setSwitchLogFileNow$mirai_console_terminal((Function0<Unit>)((Function0)new Function0<Unit>(logDir, outputLock, output){
            final /* synthetic */ File $logDir;
            final /* synthetic */ Object $outputLock;
            final /* synthetic */ AtomicReference<RandomAccessFile> $output;
            {
                this.$logDir = $logDir;
                this.$outputLock = $outputLock;
                this.$output = $output;
                super(0, Intrinsics.Kotlin.class, "switchLogFile", "startup$switchLogFile(Ljava/io/File;Ljava/lang/Object;Ljava/util/concurrent/atomic/AtomicReference;)V", 0);
            }

            public final void invoke() {
                LoggingServiceI.access$startup$switchLogFile(this.$logDir, this.$outputLock, this.$output);
            }
        }));
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.threadDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, outputLock, output, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LoggingServiceI this$0;
            final /* synthetic */ Object $outputLock;
            final /* synthetic */ AtomicReference<RandomAccessFile> $output;
            {
                this.this$0 = $receiver;
                this.$outputLock = $outputLock;
                this.$output = $output;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                        // 2 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = LoggingServiceI.access$getPipeline$p(this.this$0).receive((Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        nextLine = (String)v0;
                        var4_5 = this.$outputLock;
                        var5_6 = this.$output;
                        var6_7 = var4_5;
                        synchronized (var6_7) {
                            $i$a$-synchronized-LoggingServiceI$startup$2$1 = false;
                            out = var5_6.get();
                            $i$a$-let-LoggingServiceI$startup$2$1$1 = false;
                            v1 = nextLine.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String).getBytes(charset)");
                            out.write(v1);
                            out.write(10);
                            var7_8 = Unit.INSTANCE;
                            ** GOTO lbl6
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        long nextDayTimeSec = Instant.now().atZone(ZoneId.systemDefault()).plus(1L, ChronoUnit.DAYS).withHour(0).withMinute(0).withSecond(0).toEpochSecond();
        ScheduledFuture<?> scheduledFuture = this.threadPool.scheduleAtFixedRate(() -> LoggingServiceI.startup$switchLogFile(logDir, outputLock, output), nextDayTimeSec * (long)1000 - System.currentTimeMillis(), TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"threadPool.scheduleAtFix\u2026it.MILLISECONDS\n        )");
        this.setAutoSplitTask$mirai_console_terminal((Future)scheduledFuture);
        JobKt.getJob((CoroutineContext)this.scope.getCoroutineContext()).invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this, outputLock, output){
            final /* synthetic */ LoggingServiceI this$0;
            final /* synthetic */ Object $outputLock;
            final /* synthetic */ AtomicReference<RandomAccessFile> $output;
            {
                this.this$0 = $receiver;
                this.$outputLock = $outputLock;
                this.$output = $output;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@Nullable Throwable it) {
                LoggingServiceI.access$getThreadPool$p(this.this$0).shutdown();
                Object object = this.$outputLock;
                AtomicReference<RandomAccessFile> atomicReference = this.$output;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    RandomAccessFile randomAccessFile = atomicReference.get();
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    private final void pushInPool(String line) {
        BuildersKt.launch((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)this.threadDispatcher), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, line, null){
            int label;
            final /* synthetic */ LoggingServiceI this$0;
            final /* synthetic */ String $line;
            {
                this.this$0 = $receiver;
                this.$line = $line;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = LoggingServiceI.access$getPipeline$p(this.this$0).send((Object)this.$line, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void pushLine$mirai_console_terminal(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Object $this$onFailure$iv = this.pipeline.trySend-JP2dKIU((Object)line);
        boolean bl = false;
        if ($this$onFailure$iv instanceof ChannelResult.Failed) {
            Throwable it = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure$iv);
            boolean bl2 = false;
            this.pushInPool(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void startup$switchLogFile(File $logDir, Object outputLock, AtomicReference<RandomAccessFile> output) {
        File latestLogFile = FilesKt.resolve((File)$logDir, (String)"latest.log");
        File targetFile = null;
        if (latestLogFile.isFile()) {
            int counter = 0;
            do {
                targetFile = FilesKt.resolve((File)$logDir, (String)("log-" + counter + ".log"));
                ++counter;
            } while (targetFile.exists());
        } else {
            targetFile = latestLogFile;
        }
        Object object = outputLock;
        synchronized (object) {
            void it;
            RandomAccessFile randomAccessFile;
            boolean bl = false;
            RandomAccessFile randomAccessFile2 = output.get();
            if (randomAccessFile2 != null) {
                randomAccessFile2.close();
            }
            if (latestLogFile != targetFile) {
                Files.move(latestLogFile.toPath(), targetFile.toPath(), new CopyOption[0]);
            }
            RandomAccessFile randomAccessFile3 = randomAccessFile = new RandomAccessFile(latestLogFile, "rw");
            AtomicReference<RandomAccessFile> atomicReference = output;
            boolean bl2 = false;
            it.seek(it.length());
            atomicReference.set(randomAccessFile);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ void access$startup$switchLogFile(File $logDir, Object outputLock, AtomicReference output) {
        LoggingServiceI.startup$switchLogFile($logDir, outputLock, output);
    }

    public static final /* synthetic */ Channel access$getPipeline$p(LoggingServiceI $this) {
        return $this.pipeline;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getThreadPool$p(LoggingServiceI $this) {
        return $this.threadPool;
    }
}

