/*
 * Decompiled with CFR 0.152.
 */
package net.magik6k.jwwf.oauth;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import net.magik6k.jwwf.handlers.ClickHandler;
import net.magik6k.jwwf.handlers.UserDataHandler;
import net.magik6k.jwwf.oauth.OAuthHandler;
import net.magik6k.jwwf.util.Json;
import net.magik6k.jwwf.widgets.basic.input.Button;

public class OAuth2Button
extends Button {
    private final OAuth2Button thisButton;
    private String accessToken;
    private final Ref<OAuthHandler> authHandler = new Ref();
    private final String clientID;
    private final String clientSecret;
    private final String tokenExchangeUrl;

    public OAuth2Button(String label, final String clientID, final String clientSecret, final String authUrl, final String scopes, final String redirectUrl, final String tokenExchangeUrl, OAuthHandler _authHandler) {
        super(label);
        this.thisButton = this;
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.tokenExchangeUrl = tokenExchangeUrl;
        super.setHandler(new ClickHandler(){

            public void clicked() {
                OAuth2Button.this.thisButton.user.getUserData().get("__jwwf.oauth.token", new UserDataHandler(){

                    public void data(String key, String value) throws Exception {
                        if (value.equals("")) {
                            OAuth2Button.this.thisButton.user.getUserData().get("__jwwf.oauth.code", new UserDataHandler(){

                                public void data(String codeKey, String codeValue) throws Exception {
                                    if (codeValue.equals("")) {
                                        OAuth2Button.this.sendUserAuthorization(authUrl, clientID, redirectUrl, scopes);
                                    } else {
                                        OAuth2Button.this.doTokenExchange(tokenExchangeUrl, codeValue, clientID, clientSecret);
                                    }
                                }
                            });
                        } else {
                            OAuth2Button.this.accessToken = value;
                            ((OAuthHandler)((OAuth2Button)OAuth2Button.this).authHandler.ref).authorized(OAuth2Button.this.accessToken);
                        }
                    }
                });
            }
        });
        this.authHandler.ref = _authHandler;
    }

    private void doTokenExchange(String tokenExchangeUrl, String code, String clientID, String clientSecret) {
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)new URL(tokenExchangeUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("User-Agent", "JWWF-OAuth/2.0");
            connection.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(connection.getOutputStream());
            writer.writeBytes("code=" + code + "&client_id=" + clientID + "&client_secret=" + clientSecret);
            writer.flush();
            writer.close();
            connection.getResponseCode();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            String[] pairs = response.toString().split("\\&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length < 2) continue;
                String name = URLDecoder.decode(fields[0], "UTF-8");
                String value = URLDecoder.decode(fields[1], "UTF-8");
                values.put(name, value);
            }
            if (values.get("access_token") != null) {
                this.accessToken = (String)values.get("access_token");
                this.user.getUserData().set("__jwwf.oauth.token", this.accessToken);
                ((OAuthHandler)this.authHandler.ref).authorized(this.accessToken);
            } else {
                this.user.getUserData().set("__jwwf.oauth.code", "");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void sendUserAuthorization(String authUrl, String clientID, String redirectUrl, String scopes) {
        try {
            this.user.sendGlobal("JWWFOauth-go", "{\"url\":" + Json.escapeString((String)(authUrl + "?client_id=" + clientID + "&redirect_uri=" + URLEncoder.encode(redirectUrl, "UTF-8") + "&scope=" + URLEncoder.encode(scopes, "UTF-8"))) + "}");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    protected void onAttach() {
        super.onAttach();
        this.thisButton.user.getUserData().get("__jwwf.oauth.token", new UserDataHandler(){

            public void data(String key, String value) throws Exception {
                if (value.equals("")) {
                    OAuth2Button.this.thisButton.user.getUserData().get("__jwwf.oauth.code", new UserDataHandler(){

                        public void data(String codeKey, String codeValue) throws Exception {
                            if (!codeValue.equals("")) {
                                OAuth2Button.this.doTokenExchange(OAuth2Button.this.tokenExchangeUrl, codeValue, OAuth2Button.this.clientID, OAuth2Button.this.clientSecret);
                            }
                        }
                    });
                } else {
                    OAuth2Button.this.accessToken = value;
                    ((OAuthHandler)((OAuth2Button)OAuth2Button.this).authHandler.ref).authorized(OAuth2Button.this.accessToken);
                }
            }
        });
    }

    public String getAuthorizationStatus() {
        return this.accessToken;
    }

    @Deprecated
    public final Button setHandler(ClickHandler clickHandler) {
        throw new IllegalStateException("Cannot set click handler of this button");
    }

    private static class Ref<T> {
        public T ref;

        private Ref() {
        }
    }
}

