/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.pdf;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.text.PDFTextStripper;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.converter.PsType0ToOpenTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFontExtractor
extends PDFTextStripper {
    private static final String[] HELP_CODES = new String[]{"-h", "help", "--help", "/?"};
    private static final String DEFAULT_EXTRACT_PATH = "fonts/";
    private FontVerter.FontFormat extractFormat = FontVerter.FontFormat.OTF;
    private static Logger log = LoggerFactory.getLogger(PdfFontExtractor.class);
    private PDPage pdpage;
    private ExtractFontStrategy extractStrategy;

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || Arrays.asList(HELP_CODES).contains(args[0])) {
            System.out.println("Usage: PdfFontExtractor <pdf file or directory containing pdf files>");
            System.out.println("Options: ");
            System.out.println("-ff=<format> Font format to save the fonts as. <format> = WOFF1, WOFF2, OTF. Defaults to OTF.");
            System.out.println("-dir=<path> Directory to extract to. <path> = font extract directory. Defaults to {current dir}/fonts/");
            System.exit(1);
        }
        String extractPath = DEFAULT_EXTRACT_PATH;
        FontVerter.FontFormat format = FontVerter.FontFormat.OTF;
        for (String argOn : args) {
            String value = argOn.replaceAll("-[^=]*=", "");
            if (argOn.startsWith("-ff=")) {
                format = FontVerter.FontFormat.fromString(value);
                continue;
            }
            if (!argOn.startsWith("-dir=")) continue;
            extractPath = value;
        }
        File pdf = new File(args[0]);
        if (pdf.isDirectory()) {
            List pdfFiles = (List)FileUtils.listFiles((File)pdf, (String[])new String[]{"pdf"}, (boolean)true);
            for (File fileOn : pdfFiles) {
                try {
                    PdfFontExtractor.extractPdfFonts(extractPath, fileOn, format);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            PdfFontExtractor.extractPdfFonts(extractPath, pdf, format);
        }
    }

    private static void extractPdfFonts(String extractPath, File pdfFile, FontVerter.FontFormat format) throws IOException {
        File fontExtractDir = new File(extractPath);
        if (!fontExtractDir.exists()) {
            fontExtractDir.mkdir();
        }
        PDDocument pdf = PDDocument.load((File)pdfFile);
        PdfFontExtractor fontExtractor = new PdfFontExtractor();
        fontExtractor.setExtractFormat(format);
        fontExtractor.extractFontsToDir(pdf, extractPath);
        pdf.close();
    }

    public void extractFontsToDir(File pdf, String path) throws IOException {
        PDDocument doc = PDDocument.load((File)pdf);
        this.extractFontsToDir(doc, path);
        doc.close();
    }

    public void extractFontsToDir(byte[] pdf, String path) throws IOException {
        PDDocument doc = PDDocument.load((byte[])pdf);
        this.extractFontsToDir(doc, path);
        doc.close();
    }

    public void extractFontsToDir(PDDocument pdf, File path) throws IOException {
        this.extractFontsToDir(pdf, path.getPath() + "/");
    }

    public void extractFontsToDir(PDDocument pdf, String path) throws IOException {
        this.extractStrategy = new ExtractToDirStrategy(path, this.extractFormat);
        StringWriter output = new StringWriter();
        this.writeText(pdf, output);
        ((Writer)output).close();
    }

    public List<FVFont> extractToFVFonts(PDDocument pdf) throws IOException {
        this.extractStrategy = new ExtractFVFontStrategy();
        StringWriter output = new StringWriter();
        this.writeText(pdf, output);
        ((Writer)output).close();
        return ((ExtractFVFontStrategy)this.extractStrategy).extractedFvFonts;
    }

    public List<PDFont> extractToPDFBoxFonts(PDDocument pdf) throws IOException {
        this.extractStrategy = new ExtractToPDFBoxFontStrategy();
        StringWriter output = new StringWriter();
        this.writeText(pdf, output);
        ((Writer)output).close();
        return ((ExtractToPDFBoxFontStrategy)this.extractStrategy).extractedFonts;
    }

    public void processPage(PDPage page) throws IOException {
        this.pdpage = page;
        this.tryExtractPageFonts();
        super.processPage(page);
    }

    protected void tryExtractPageFonts() {
        PDResources resources = this.pdpage.getResources();
        if (resources == null) {
            return;
        }
        try {
            this.extractFontResources(resources);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void extractFontResources(PDResources resources) throws IOException {
        for (COSName key : resources.getFontNames()) {
            PDFont font = resources.getFont(key);
            this.extractStrategy.extract(font);
        }
        for (COSName name : resources.getXObjectNames()) {
            PDFormXObject xObjectForm;
            PDResources formResources;
            PDXObject xobject = resources.getXObject(name);
            if (!(xobject instanceof PDFormXObject) || (formResources = (xObjectForm = (PDFormXObject)xobject).getResources()) == null) continue;
            this.extractFontResources(formResources);
        }
    }

    public static FVFont convertFont(PDFont font, FontVerter.FontFormat format) throws IOException {
        FVFont readFont = null;
        if (font instanceof PDTrueTypeFont) {
            if (font.getFontDescriptor() == null || font.getFontDescriptor().getFontFile2() == null) {
                log.warn("Skipped font: '{}'. No font file 2 found", (Object)font.getName());
                return null;
            }
            byte[] data = font.getFontDescriptor().getFontFile2().toByteArray();
            readFont = FontVerter.readFont(data);
        } else if (font instanceof PDType0Font) {
            readFont = PdfFontExtractor.convertType0FontToOpenType((PDType0Font)font);
            readFont.normalize();
        } else if (font instanceof PDType1CFont) {
            byte[] data = font.getFontDescriptor().getFontFile3().toByteArray();
            readFont = FontVerter.readFont(data);
        } else {
            log.warn("Skipped font: '{}'. FontVerter does not support font type: '{}'", (Object)font.getName(), (Object)font.getType());
        }
        if (readFont == null) {
            return null;
        }
        if (!readFont.isValid()) {
            readFont.normalize();
        }
        return FontVerter.convertFont(readFont, format);
    }

    public static FVFont convertType0FontToOpenType(PDType0Font font) throws IOException {
        PsType0ToOpenTypeConverter converter = new PsType0ToOpenTypeConverter();
        try {
            return converter.convert(font);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public FontVerter.FontFormat getExtractFormat() {
        return this.extractFormat;
    }

    public void setExtractFormat(FontVerter.FontFormat extractFormat) {
        this.extractFormat = extractFormat;
    }

    static class ExtractToDirStrategy
    extends ExtractFontStrategy {
        private String extractPath;
        private final FontVerter.FontFormat format;

        public ExtractToDirStrategy(String path, FontVerter.FontFormat format) {
            this.extractPath = path;
            this.format = format;
        }

        @Override
        public void extract(PDFont font) throws IOException {
            if (this.hasExtractedFont(font)) {
                return;
            }
            this.extractedFonts.add(font);
            FVFont saveFont = PdfFontExtractor.convertFont(font, this.format);
            if (saveFont != null && !this.extractPath.isEmpty()) {
                String fileEnding = saveFont.getProperties().getFileEnding();
                if (!this.extractPath.endsWith("/")) {
                    this.extractPath = this.extractPath + "/";
                }
                String fontFilePath = this.extractPath + font.getName() + "." + fileEnding;
                FileUtils.writeByteArrayToFile((File)new File(fontFilePath), (byte[])saveFont.getData());
                log.info("Extracted: {}", (Object)fontFilePath);
            }
        }
    }

    static class ExtractFVFontStrategy
    extends ExtractFontStrategy {
        private List<FVFont> extractedFvFonts = new ArrayList<FVFont>();

        ExtractFVFontStrategy() {
        }

        @Override
        public void extract(PDFont font) throws IOException {
            this.extractedFonts.add(font);
            FVFont convertedFont = PdfFontExtractor.convertFont(font, FontVerter.FontFormat.OTF);
            if (convertedFont != null) {
                this.extractedFvFonts.add(convertedFont);
            }
            log.info("Extracted: {}", (Object)font.getName());
        }
    }

    static class ExtractToPDFBoxFontStrategy
    extends ExtractFontStrategy {
        ExtractToPDFBoxFontStrategy() {
        }

        @Override
        public void extract(PDFont font) throws IOException {
            this.extractedFonts.add(font);
        }
    }

    static abstract class ExtractFontStrategy {
        protected List<PDFont> extractedFonts = new ArrayList<PDFont>();

        ExtractFontStrategy() {
        }

        public abstract void extract(PDFont var1) throws IOException;

        protected boolean hasExtractedFont(PDFont font) {
            for (PDFont fontOn : this.extractedFonts) {
                if (!fontOn.getName().equals(font.getName()) || fontOn.getClass() != font.getClass()) continue;
                return true;
            }
            return false;
        }
    }
}

