/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions.instructions;

import java.io.IOException;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;

public class GetInfoInstruction
extends TtfInstruction {
    @Override
    public int[] getCodeRanges() {
        return new int[]{136};
    }

    @Override
    public void read(FontDataInputStream in) throws IOException {
    }

    @Override
    public void execute(InstructionStack stack) throws IOException {
        Long infoCode = stack.popUint32();
        Long infoResult = 0L;
        if (this.isBitSet(0, infoCode)) {
            infoResult = infoResult | this.getEngineVersion();
        }
        if (this.isBitSet(1, infoCode)) {
            infoResult = infoResult | (long)(this.isRotated() << 8);
        } else if (this.isBitSet(2, infoCode)) {
            infoResult = infoResult | (long)(this.isStretched() << 9);
        }
        stack.push(infoResult);
    }

    private Long getEngineVersion() {
        if (GetInfoInstruction.isWindows()) {
            return 3L;
        }
        return 2L;
    }

    private int isStretched() {
        return 0;
    }

    private int isRotated() {
        return 0;
    }

    private boolean isBitSet(int position, Long num) {
        return (num >> position & 1L) == 1L;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }
}

