/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontNotSupportedException;
import org.mabb.fontverter.FontProperties;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.converter.FontConverter;
import org.mabb.fontverter.converter.IdentityConverter;
import org.mabb.fontverter.converter.OpenTypeToEotConverter;
import org.mabb.fontverter.converter.OtfToWoffConverter;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.CffTable;
import org.mabb.fontverter.opentype.CmapTable;
import org.mabb.fontverter.opentype.ControlValueTable;
import org.mabb.fontverter.opentype.FontProgramTable;
import org.mabb.fontverter.opentype.GlyphLocationTable;
import org.mabb.fontverter.opentype.GlyphTable;
import org.mabb.fontverter.opentype.HeadTable;
import org.mabb.fontverter.opentype.HorizontalHeadTable;
import org.mabb.fontverter.opentype.HorizontalMetricsTable;
import org.mabb.fontverter.opentype.MaximumProfileTable;
import org.mabb.fontverter.opentype.NameTable;
import org.mabb.fontverter.opentype.OS2WinMetricsTable;
import org.mabb.fontverter.opentype.OpenTypeFontProperties;
import org.mabb.fontverter.opentype.OpenTypeParser;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.OpenTypeValidator;
import org.mabb.fontverter.opentype.OtfNameConstants;
import org.mabb.fontverter.opentype.PostScriptTable;
import org.mabb.fontverter.opentype.SfntHeader;
import org.mabb.fontverter.validator.RuleValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTypeFont
implements FVFont {
    SfntHeader sfntHeader;
    private List<OpenTypeTable> tables = new ArrayList<OpenTypeTable>();
    private static Logger log = LoggerFactory.getLogger(OpenTypeFont.class);
    private File sourceFile;

    public static OpenTypeFont createBlankFont() throws IOException {
        OpenTypeFont font = new OpenTypeFont();
        font.initTable(HeadTable.createDefaultTable());
        font.initTable(OS2WinMetricsTable.createDefaultTable());
        font.initTable(HorizontalHeadTable.createDefaultTable());
        font.initTable(MaximumProfileTable.createDefaultTable());
        font.initTable(PostScriptTable.createDefaultTable(3.0f));
        font.initTable(CmapTable.createDefaultTable());
        font.initTable(HorizontalMetricsTable.createDefaultTable(font));
        font.initTable(NameTable.createDefaultTable());
        font.normalizeTables();
        return font;
    }

    public static OpenTypeFont createBlankTtfFont() throws IOException {
        OpenTypeFont font = new OpenTypeFont();
        font.initTable(HeadTable.createDefaultTable());
        font.initTable(OS2WinMetricsTable.createDefaultTable());
        font.initTable(HorizontalHeadTable.createDefaultTable());
        font.initTable(MaximumProfileTable.createDefaultV1Table());
        font.initTable(PostScriptTable.createDefaultTable(3.0f));
        font.initTable(CmapTable.createDefaultTable());
        font.initTable(HorizontalMetricsTable.createDefaultTable(font));
        font.initTable(new ControlValueTable());
        font.initTable(new GlyphTable());
        font.initTable(new FontProgramTable());
        font.initTable(NameTable.createDefaultTable());
        font.normalizeTables();
        return font;
    }

    public OpenTypeFont() {
        this.sfntHeader = new SfntHeader();
    }

    @Override
    public boolean detectFormat(byte[] fontFile) {
        String[] headerMagicNums;
        for (String magicNumOn : headerMagicNums = new String[]{"OTTO", "\u0000\u0001\u0000\u0000", "\u0000\u0002\u0000\u0000", "\u0000\u0002\u0005\u0000"}) {
            if (!FontVerterUtils.bytesStartsWith(fontFile, magicNumOn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(byte[] fontFile) throws IOException {
        try {
            new OpenTypeParser().parse(fontFile, this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        String name = this.getNameTable().getName(OtfNameConstants.RecordType.FULL_FONT_NAME);
        if (StringUtils.isEmpty((CharSequence)name) && this.isCffType()) {
            name = this.getCffTable().getCffFont().getFullName();
        }
        return name;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().size() == 0;
    }

    @Override
    public List<RuleValidator.FontValidatorError> getValidationErrors() {
        try {
            OpenTypeValidator validator = new OpenTypeValidator();
            return validator.validate(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RuleValidator.FontValidatorError error = new RuleValidator.FontValidatorError(RuleValidator.ValidatorErrorType.ERROR, String.format("Exception running validator: %s %s", ex.getMessage(), ex.getClass()));
            ArrayList<RuleValidator.FontValidatorError> errors = new ArrayList<RuleValidator.FontValidatorError>();
            errors.add(error);
            return errors;
        }
    }

    @Override
    public void normalize() throws IOException {
        if (this.getOs2() == null) {
            this.createNewOS2WinMetricsTable();
        }
        if (this.getNameTable() == null) {
            this.setName(NameTable.createDefaultTable());
        }
        if (this.getPost() == null) {
            this.setPost(PostScriptTable.createDefaultTable(this.getOpenTypeVersion()));
        }
        this.finalizeFont();
    }

    private void createNewOS2WinMetricsTable() {
        HorizontalHeadTable hhea = this.getHhea();
        OS2WinMetricsTable table = OS2WinMetricsTable.createDefaultTable();
        this.setOs2(table);
    }

    @Override
    public FontProperties getProperties() {
        return OpenTypeFontProperties.createFrom(this);
    }

    @Override
    public FontConverter createConverterForType(FontVerter.FontFormat fontFormat) throws FontNotSupportedException {
        switch (fontFormat) {
            case OTF: {
                return new IdentityConverter();
            }
            case WOFF1: {
                return new OtfToWoffConverter();
            }
            case WOFF2: {
                return new OtfToWoffConverter.OtfToWoff2Converter();
            }
            case EOT: {
                return new OpenTypeToEotConverter();
            }
        }
        throw new FontNotSupportedException("Font conversion not supported");
    }

    private <T extends OpenTypeTable> T initTable(T table) {
        table.font = this;
        this.tables.add(table);
        return table;
    }

    public void addTable(OpenTypeTable table) {
        this.tables.add(table);
    }

    private List<OpenTypeTable> descendingSortedTables() {
        Collections.sort(this.tables, new Comparator<OpenTypeTable>(){

            @Override
            public int compare(OpenTypeTable left, OpenTypeTable right) {
                return left.getTableType().compareTo(right.getTableType());
            }
        });
        return this.tables;
    }

    @Override
    public byte[] getData() throws IOException {
        this.clearTableDataCache();
        this.finalizeFont();
        byte[] data = this.getRawData();
        this.clearTableDataCache();
        return data;
    }

    public void finalizeFont() throws IOException {
        for (OpenTypeTable tableOn : this.tables) {
            tableOn.resetCalculations();
        }
        this.descendingSortedTables();
        this.normalizeTables();
        this.calculateOffsets(this.tables);
        for (OpenTypeTable tableOn : this.tables) {
            tableOn.finalizeRecord();
        }
        this.getHead().clearDataCache();
        this.getHead().checksumAdjustment(this.getRawData());
    }

    private void normalizeTables() throws IOException {
        if (this.sfntHeader.sfntFlavor.isEmpty()) {
            this.sfntHeader.sfntFlavor = this.determineSfntFlavor();
        }
        if (this.getCmap() != null && this.getMxap() != null && !this.getMxap().isFromParsedFont) {
            this.getMxap().setNumGlyphs(this.getCmap().getGlyphCount());
        }
        for (OpenTypeTable tableOn : this.tables) {
            tableOn.font = this;
            tableOn.normalize();
        }
    }

    private String determineSfntFlavor() {
        if (this.getCffTable() != null) {
            return "OTTO";
        }
        if (this.getPost() != null) {
            return SfntHeader.toVersionString(this.getPost().getVersion());
        }
        return "\u0000\u0001\u0000\u0000";
    }

    private byte[] getRawData() throws IOException {
        FontDataOutputStream out = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        this.sfntHeader.setNumTables(this.tables.size());
        out.write(this.sfntHeader.getData());
        for (OpenTypeTable tableOn : this.tables) {
            out.write(tableOn.getRecordData());
        }
        for (OpenTypeTable tableOn : this.tables) {
            out.write(tableOn.getData());
        }
        return out.toByteArray();
    }

    private void calculateOffsets(List<OpenTypeTable> tables) throws IOException {
        int offset = tables.size() * 16 + 12;
        for (OpenTypeTable tableOn : tables) {
            tableOn.setOffset(offset);
            offset += tableOn.getData().length;
        }
    }

    public void orderTablesByDependencies() {
        Collections.sort(this.getTables(), new Comparator<OpenTypeTable>(){

            @Override
            public int compare(OpenTypeTable o1, OpenTypeTable o2) {
                int order2;
                int order1 = OpenTypeFont.dependencyOrderForTable(o1);
                return order1 < (order2 = OpenTypeFont.dependencyOrderForTable(o2)) ? -1 : (order1 == order2 ? 0 : 1);
            }
        });
    }

    private static int dependencyOrderForTable(OpenTypeTable table) {
        if (table instanceof HorizontalHeadTable) {
            return 1;
        }
        if (table instanceof HorizontalMetricsTable) {
            return 2;
        }
        if (table instanceof GlyphLocationTable) {
            return 3;
        }
        if (table instanceof GlyphTable) {
            return 4;
        }
        return 0;
    }

    private void clearTableDataCache() {
        for (OpenTypeTable tableOn : this.tables) {
            tableOn.clearDataCache();
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void removeTable(Class toRemoveType) {
        OpenTypeTable toRemoveTable = null;
        for (OpenTypeTable tableOn : this.tables) {
            if (tableOn.getClass() != toRemoveType) continue;
            toRemoveTable = tableOn;
        }
        if (toRemoveTable != null) {
            this.tables.remove(toRemoveTable);
        }
    }

    private <T extends OpenTypeTable> T findTableType(Class type) {
        for (OpenTypeTable tableOn : this.tables) {
            if (tableOn.getClass() != type) continue;
            return (T)tableOn;
        }
        return null;
    }

    private void setTable(OpenTypeTable toAdd) {
        this.removeTable(toAdd.getClass());
        this.tables.add(toAdd);
    }

    public boolean isCffType() {
        return this.sfntHeader.sfntFlavor.equals("OTTO");
    }

    public boolean isTrueTypeOutlineType() {
        return !this.sfntHeader.sfntFlavor.equals("OTTO");
    }

    public float getOpenTypeVersion() {
        return this.sfntHeader.openTypeVersion();
    }

    public HeadTable getHead() {
        return (HeadTable)this.findTableType(HeadTable.class);
    }

    public void setHead(HeadTable head) {
        this.setTable(head);
    }

    public HorizontalHeadTable getHhea() {
        return (HorizontalHeadTable)this.findTableType(HorizontalHeadTable.class);
    }

    public void setHhea(HorizontalHeadTable hhea) {
        this.setTable(hhea);
    }

    public HorizontalMetricsTable getHmtx() {
        return (HorizontalMetricsTable)this.findTableType(HorizontalMetricsTable.class);
    }

    public void setHmtx(HorizontalMetricsTable hmtx) {
        this.setTable(hmtx);
    }

    public OS2WinMetricsTable getOs2() {
        return (OS2WinMetricsTable)this.findTableType(OS2WinMetricsTable.class);
    }

    public void setOs2(OS2WinMetricsTable os2) {
        this.setTable(os2);
    }

    public PostScriptTable getPost() {
        return (PostScriptTable)this.findTableType(PostScriptTable.class);
    }

    public void setPost(PostScriptTable post) {
        this.setTable(post);
    }

    public CmapTable getCmap() {
        return (CmapTable)this.findTableType(CmapTable.class);
    }

    public void setCmap(CmapTable cmap) {
        this.setTable(cmap);
    }

    public MaximumProfileTable getMxap() {
        return (MaximumProfileTable)this.findTableType(MaximumProfileTable.class);
    }

    public void setMxap(MaximumProfileTable mxap) {
        this.setTable(mxap);
    }

    public ControlValueTable getCvt() {
        return (ControlValueTable)this.findTableType(ControlValueTable.class);
    }

    public void setCvt(ControlValueTable cvt) {
        this.setTable(cvt);
    }

    public NameTable getNameTable() {
        return (NameTable)this.findTableType(NameTable.class);
    }

    public void setName(NameTable name) {
        this.setTable(name);
    }

    public CffTable getCffTable() {
        return (CffTable)this.findTableType(CffTable.class);
    }

    public GlyphLocationTable getLocaTable() {
        return (GlyphLocationTable)this.findTableType(GlyphLocationTable.class);
    }

    public GlyphTable getGlyfTable() {
        return (GlyphTable)this.findTableType(GlyphTable.class);
    }

    public FontProgramTable getFpgmTable() {
        return (FontProgramTable)this.findTableType(FontProgramTable.class);
    }

    public List<OpenTypeTable> getTables() {
        return this.tables;
    }

    public SfntHeader getSfntHeader() {
        return this.sfntHeader;
    }
}

