/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlValueTable
extends OpenTypeTable {
    private static final Logger log = LoggerFactory.getLogger(ControlValueTable.class);
    private List<Short> values = new LinkedList<Short>();

    @Override
    public String getTableType() {
        return "cvt ";
    }

    @Override
    public void readData(byte[] data) throws IOException {
        FontDataInputStream input = new FontDataInputStream(data);
        while (input.available() >= 2) {
            this.values.add(input.readShort());
        }
        if (input.available() == 1) {
            log.info("original cvt table data length not divisble by two, adding 1 byte padding.");
            this.values.add(Short.valueOf(input.readByte()));
        }
    }

    @Override
    protected byte[] generateUnpaddedData() throws IOException {
        FontDataOutputStream out = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        for (Short valueOn : this.values) {
            out.writeShort(valueOn.shortValue());
        }
        return out.toByteArray();
    }

    public List<Short> getValues() {
        return this.values;
    }

    public Short getValue(Long index) throws CvtValueNotFoundException {
        if (index > (long)this.values.size()) {
            throw new CvtValueNotFoundException();
        }
        return this.values.get(index.intValue());
    }

    public static class CvtValueNotFoundException
    extends IOException {
    }
}

