/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.mabb.fontverter.FontVerterUtils;

public abstract class WoffTable {
    int transformLength;
    int originalLength;
    protected byte[] tableData;
    protected byte[] compressedData;
    protected int paddingAdded = 0;

    public WoffTable(byte[] table) {
        this.tableData = table;
        this.originalLength = table.length;
    }

    protected abstract byte[] compress(byte[] var1) throws IOException;

    protected abstract byte[] getDirectoryData() throws IOException;

    public byte[] getCompressedData() throws IOException {
        if (this.compressedData == null) {
            this.compressedData = this.compress(this.tableData);
            if (this.origLength() < this.compressedData.length) {
                this.compressedData = this.tableData;
            }
        }
        return this.compressedData;
    }

    protected byte[] padTableData(byte[] tableData) {
        byte[] padding = FontVerterUtils.tablePaddingNeeded(tableData);
        if (padding.length != 0) {
            this.paddingAdded = padding.length;
        }
        return ArrayUtils.addAll((byte[])tableData, (byte[])padding);
    }

    public int origLength() {
        return this.tableData.length;
    }

    public byte[] getTableData() {
        return this.tableData;
    }

    public abstract String getTag();
}

