/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.woff.Woff1Font;
import org.mabb.fontverter.woff.WoffFont;
import org.mabb.fontverter.woff.WoffHeader;
import org.mabb.fontverter.woff.WoffTable;

public class WoffParser {
    protected WoffFont font;
    protected FontDataInputStream input;

    public WoffFont parse(byte[] data) throws IOException {
        return this.parse(data, null);
    }

    public WoffFont parse(byte[] data, WoffFont readTo) throws IOException {
        this.font = readTo;
        this.initalizeFont();
        this.input = new FontDataInputStream(data);
        this.font.header = this.parseHeader();
        this.parseTables();
        return this.font;
    }

    protected void initalizeFont() {
        if (this.font == null) {
            this.font = WoffFont.createBlankFont(1);
        }
    }

    private WoffHeader parseHeader() throws IOException {
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        WoffHeader header = (WoffHeader)deserializer.deserialize(this.input, WoffHeader.class);
        if (!header.isSignatureValid()) {
            throw new IOException("Woff header signature not recognized");
        }
        return header;
    }

    protected void parseTables() throws IOException {
        for (int i = 0; i < this.font.header.numTables; ++i) {
            this.parseDirectoryEntry();
        }
        for (WoffTable tableOn : this.font.getTables()) {
            this.parseTableData((Woff1Font.Woff1Table)tableOn);
        }
    }

    private void parseTableData(Woff1Font.Woff1Table tableOn) throws IOException {
        this.input.seek(tableOn.offset);
        byte[] compressedData = this.input.readBytes(tableOn.transformLength);
        tableOn.readCompressedData(compressedData);
    }

    private void parseDirectoryEntry() throws IOException {
        Woff1Font.Woff1Table table = (Woff1Font.Woff1Table)this.font.createTable();
        table.tag = this.input.readString(4);
        table.offset = this.input.readInt();
        table.transformLength = this.input.readInt();
        table.originalLength = this.input.readInt();
        table.checksum = this.input.readUnsignedInt();
        this.font.getTables().add(table);
    }
}

