/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtfInstructionParser {
    private static List<Class> instructionTypes;
    private static final Object factoryLock;
    private static Logger log;
    InstructionStack stack = new InstructionStack();

    public List<TtfInstruction> parse(byte[] data) throws IOException, InstantiationException, IllegalAccessException {
        LinkedList<TtfInstruction> instructions = new LinkedList<TtfInstruction>();
        FontDataInputStream in = new FontDataInputStream(data);
        while (in.available() > 0) {
            int code = in.readByte() & 0xFF;
            TtfInstruction instruction = TtfInstructionParser.createFromCode(code);
            if (instruction == null) {
                log.info("No instruction found for code: 0x" + Integer.toHexString(code) + "/" + code);
                log.info("Position: " + in.getPosition() + " Length: " + data.length);
                break;
            }
            instruction.stack = this.stack;
            instruction.read(in);
            instructions.add(instruction);
            log.info("Parsed instruction: " + instruction.getClass().getSimpleName() + " code: 0x" + Integer.toHexString(code) + "/" + code);
        }
        return instructions;
    }

    public static TtfInstruction createFromCode(int code) throws IllegalAccessException, InstantiationException, IOException {
        TtfInstructionParser.initInstructionTypes();
        for (Class typeOn : instructionTypes) {
            TtfInstruction instructOn = (TtfInstruction)typeOn.newInstance();
            if (!instructOn.doesMatch(code)) continue;
            instructOn.code = code;
            return instructOn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initInstructionTypes() {
        Object object = factoryLock;
        synchronized (object) {
            if (instructionTypes == null) {
                Reflections reflections = new Reflections("org.mabb.fontverter", new Scanner[0]);
                Set adapterClasses = reflections.getSubTypesOf(TtfInstruction.class);
                instructionTypes = Arrays.asList(adapterClasses.toArray(new Class[adapterClasses.size()]));
            }
        }
    }

    InstructionStack getStack() {
        return this.stack;
    }

    static {
        factoryLock = new Object();
        log = LoggerFactory.getLogger(TtfInstructionParser.class);
    }

    public static class AlignToReferencePoint
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{60};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            long p1 = this.stack.popUint32();
            long p2 = this.stack.popUint32();
        }
    }

    public static class AlignPoints
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{39};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            long p1 = this.stack.popUint32();
            long p2 = this.stack.popUint32();
        }
    }

    public static class AddInstruction
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{96};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            float n1 = this.stack.popF26Dot6();
            float n2 = this.stack.popF26Dot6();
            this.stack.pushF26Dot6(n1 + n2);
        }
    }

    public static class AbsoluteValue
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{100};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            double n = this.stack.popF26Dot6();
            this.stack.pushF26Dot6((float)Math.abs(n));
        }
    }

    public static class AdjustAngle
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{127};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            this.stack.popUint32();
        }
    }

    public static class InterpolateUntouchedPoints
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{48, 49};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
        }
    }

    public static class SetZonePointer2
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{21};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
        }
    }

    public static class CallFunction
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{43};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            long func = this.stack.popUint32();
        }
    }

    public static class PushWords
    extends TtfInstruction {
        @Override
        public int[] getCodeRanges() {
            return new int[]{184, 191};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            int numWords = this.code - 184 + 1;
            in.readBytes(numWords * 2);
        }
    }

    public static class PushBytes
    extends TtfInstruction {
        private int numBytes;
        private byte[] bytes;

        @Override
        public int[] getCodeRanges() {
            return new int[]{176, 183};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            this.numBytes = this.code - 176 + 1;
            if (in.available() < this.numBytes) {
                throw new IOException("Num PushBytes greater than available input stream data.");
            }
            for (byte byteOn : this.bytes = in.readBytes(this.numBytes)) {
                this.stack.push(byteOn);
            }
        }
    }

    public static class PushNBytes
    extends TtfInstruction {
        private byte numBytes;
        private byte[] bytes;

        @Override
        public int[] getCodeRanges() {
            return new int[]{64};
        }

        @Override
        public void read(FontDataInputStream in) throws IOException {
            this.numBytes = in.readByte();
            for (byte byteOn : this.bytes = in.readBytes(this.numBytes)) {
                this.stack.push(byteOn);
            }
        }
    }

    public static abstract class TtfInstruction {
        public InstructionStack stack;
        public int code;

        public abstract int[] getCodeRanges();

        public abstract void read(FontDataInputStream var1) throws IOException;

        public boolean doesMatch(int code) {
            int[] range = this.getCodeRanges();
            if (this.getCodeRanges().length == 1) {
                return code == range[0];
            }
            return code >= range[0] && code <= range[1];
        }
    }
}

