/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.List;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.OpenTypeTable;

public class PostScriptTable
extends OpenTypeTable {
    @DataTypeProperty(dataType=DataTypeProperty.DataType.FIXED32)
    private float version;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.FIXED32)
    private float italicAngle;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short underlinePosition;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short underlineThickness;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long isFixedPitch;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long minMemType42;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long maxMemType42;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long mimMemType1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long maxMemType1;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, includeIf="isVersion2")
    private int numGlyphs = 0;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, isArray=true, includeIf="isVersion2", arrayLength="getNumGlyphs")
    private Integer[] glyphNameIndex = new Integer[0];
    @DataTypeProperty(dataType=DataTypeProperty.DataType.PASCAL_STRING, isArray=true, includeIf="isVersion2", arrayLength="getNumGlyphs")
    private String[] glyphNames = new String[0];

    @Override
    public String getTableType() {
        return "post";
    }

    public static PostScriptTable createDefaultTable(float version) {
        PostScriptTable table = new PostScriptTable();
        table.version = version;
        table.italicAngle = 0.0f;
        table.underlinePosition = (short)-143;
        table.underlineThickness = (short)20;
        table.isFixedPitch = 0L;
        table.minMemType42 = 0L;
        table.maxMemType42 = 0L;
        table.mimMemType1 = 0L;
        table.maxMemType1 = 0L;
        return table;
    }

    @Override
    public void readData(byte[] data) throws IOException {
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        deserializer.setRecoverFromEOF(true);
        deserializer.deserialize(data, (Object)this);
    }

    public float getVersion() {
        return this.version;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public long getMimMemType1() {
        return this.mimMemType1;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public boolean isVersion2() {
        return this.getVersion() == 2.0f;
    }

    public int getNumGlyphs() {
        if (this.numGlyphs > 257) {
            return this.numGlyphs - 258;
        }
        return this.numGlyphs;
    }

    @Override
    void normalize() throws IOException {
        if (this.font.getCmap() != null) {
            this.loadGlyphsFromCmap();
        }
        super.normalize();
    }

    private void loadGlyphsFromCmap() {
        this.numGlyphs = this.font.getCmap().getGlyphCount();
        if (this.numGlyphs < 1) {
            return;
        }
        this.font.getCmap().getGlyphMappings();
        this.glyphNameIndex = new Integer[this.numGlyphs];
        this.glyphNames = new String[this.numGlyphs];
        List<GlyphMapReader.GlyphMapping> mappings = this.font.getCmap().getGlyphMappings();
        for (int i = 0; i < this.numGlyphs - 1; ++i) {
            GlyphMapReader.GlyphMapping entryOn = mappings.get(0);
            this.glyphNameIndex[i] = entryOn.glyphId;
            this.glyphNames[i] = entryOn.name;
        }
        this.glyphNameIndex[this.numGlyphs - 1] = 0;
        this.glyphNames[this.numGlyphs - 1] = ".notdef";
    }
}

