/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.nio.charset.Charset;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.DataTypeSerializerException;
import org.mabb.fontverter.opentype.OtfNameConstants;

class NameRecord {
    static final int NAME_RECORD_SIZE = 12;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=0)
    int platformID;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=1)
    int encodingID;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=2)
    int languageID;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=3)
    int nameID;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=5)
    int offset;
    private String string;

    public static NameRecord createWindowsRecord(String name, OtfNameConstants.RecordType type, OtfNameConstants.Language language) {
        NameRecord record = new NameRecord(name);
        record.setNameID(type.getValue());
        record.platformID = 3;
        record.encodingID = 1;
        record.languageID = language.getValue();
        return record;
    }

    public static NameRecord createMacRecord(String name, OtfNameConstants.RecordType type, OtfNameConstants.Language language) {
        NameRecord record = new NameRecord(name);
        record.setNameID(type.getValue());
        record.platformID = 1;
        record.encodingID = 0;
        record.languageID = 0;
        return record;
    }

    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT, order=4)
    int getLength() {
        return this.getStringData().length;
    }

    private NameRecord(String name) {
        this.string = name;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getNameID() {
        return this.nameID;
    }

    public void setNameID(int nameID) {
        this.nameID = nameID;
    }

    public byte[] getStringData() {
        return this.string.getBytes(this.getEncoding());
    }

    public String getRawString() {
        return this.string;
    }

    private Charset getEncoding() {
        if (this.platformID == 3) {
            return Charset.forName("UTF-16");
        }
        return Charset.forName("ISO_8859_1");
    }

    public void setStringData(String stringData) {
        this.string = stringData;
    }

    public byte[] getRecordData() throws DataTypeSerializerException {
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(this);
    }
}

