/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.OpenTypeTable;

public class HeadTable
extends OpenTypeTable {
    @DataTypeProperty(dataType=DataTypeProperty.DataType.FIXED32)
    private float version;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.FIXED32)
    private float fontRevision;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long checkSumAdjustment;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.ULONG)
    private long magicNumber;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int flags;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int unitsPerEm;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.LONG_DATE_TIME)
    private Calendar created;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.LONG_DATE_TIME)
    private Calendar modified;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short xMin;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short yMin;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short xMax;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short yMax;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int macStyle;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    private int lowestRecPPEM;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short fontDirectionHint;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short indexToLocFormat;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.SHORT)
    private short glyphDataFormat;

    @Override
    public String getTableType() {
        return "head";
    }

    @Override
    void normalize() throws IOException {
        super.normalize();
        this.flags = 4097;
    }

    public static HeadTable createDefaultTable() {
        HeadTable table = new HeadTable();
        table.version = 1.0f;
        table.fontRevision = 1.0f;
        table.checkSumAdjustment = 0L;
        table.magicNumber = 1594834165L;
        table.flags = 11;
        table.unitsPerEm = 1000;
        table.created = HeadTable.createDefaultDate();
        table.modified = HeadTable.createDefaultDate();
        table.xMin = (short)26;
        table.yMin = (short)-2;
        table.xMax = (short)1200;
        table.yMax = (short)800;
        table.macStyle = 0;
        table.lowestRecPPEM = 6;
        table.fontDirectionHint = (short)2;
        table.indexToLocFormat = 1;
        table.glyphDataFormat = 0;
        return table;
    }

    private static Calendar createDefaultDate() {
        Calendar created = GregorianCalendar.getInstance();
        created.set(1991, 2, 21);
        return created;
    }

    public void checksumAdjustment(byte[] fontBytes) throws IOException {
        this.checkSumAdjustment = -1313820742L - FontVerterUtils.getTableChecksum(fontBytes);
    }

    public short getyMin() {
        return this.yMin;
    }

    public void setMinY(short yMin) {
        this.yMin = yMin;
    }

    public short getxMin() {
        return this.xMin;
    }

    public void setMinX(short xMin) {
        this.xMin = xMin;
    }

    public short getxMax() {
        return this.xMax;
    }

    public void setMaxX(short xMax) {
        this.xMax = xMax;
    }

    public short getyMax() {
        return this.yMax;
    }

    public void setMaxY(short yMax) {
        this.yMax = yMax;
    }

    @Override
    void resetCalculations() {
        this.checkSumAdjustment = 0L;
        super.resetCalculations();
    }

    public boolean isLongIndexToLocFormat() {
        return this.indexToLocFormat == 1;
    }
}

