/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.FontDataOutputStream;

public class FontDataInputStream
extends DataInputStream {
    private final SeekableByteArrayInputStream byteInput;
    Charset encoding = FontDataOutputStream.OPEN_TYPE_CHARSET;

    public FontDataInputStream(byte[] data) {
        super(new SeekableByteArrayInputStream(data));
        this.byteInput = (SeekableByteArrayInputStream)this.in;
    }

    public long readUnsignedInt() throws IOException {
        long byte1 = this.read();
        long byte2 = this.read();
        long byte3 = this.read();
        long byte4 = this.read();
        if (byte4 < 0L) {
            throw new EOFException();
        }
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
    }

    public String readString(int length) throws IOException {
        byte[] bytes = this.readBytes(length);
        return new String(bytes, this.encoding);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.in.read();
        }
        return bytes;
    }

    public void seek(int offset) {
        this.byteInput.seek(offset);
    }

    public int readUIntBase128() throws IOException {
        int accum = 0;
        for (int i = 0; i < 5; ++i) {
            byte data_byte = this.readByte();
            if (i == 0 && data_byte == 128) {
                throw new IOException("No leading 0's");
            }
            if ((accum & 0xFE000000) > 0) {
                throw new IOException("UIntBase128 read error If any of top 7 bits are set then << 7 would overflow");
            }
            accum = accum << 7 | data_byte & 0x7F;
            if ((data_byte & 0x80) != 0) continue;
            return accum;
        }
        throw new IOException("UIntBase128 sequence exceeds 5 bytes");
    }

    public float readFixed32() throws IOException {
        float num = this.readShort();
        num = (float)((double)num + (double)this.readUnsignedShort() / 65536.0);
        return num;
    }

    public int getPosition() {
        return this.byteInput.getPosition();
    }

    public int[] readSplitBits(int numUpperBits) throws IOException {
        int fulByte = this.read();
        int upper = FontVerterUtils.readUpperBits(fulByte, numUpperBits);
        int lower = FontVerterUtils.readLowerBits(fulByte, 8 - numUpperBits);
        return new int[]{upper, lower};
    }

    public int[] readUnsignedShortArray(int length) throws IOException {
        int[] readArray = new int[length];
        for (int i = 0; i < length; ++i) {
            readArray[i] = this.readUnsignedShort();
        }
        return readArray;
    }

    protected static class SeekableByteArrayInputStream
    extends ByteArrayInputStream {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void seek(int n) {
            this.pos = n;
        }

        public int getPosition() {
            return this.pos;
        }
    }
}

