/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.converter;

import java.io.IOException;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontConverter;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.woff.WoffFont;

public class OtfToWoffConverter
implements FontConverter {
    OpenTypeFont otfFont;
    private WoffFont woffFont;
    protected int woffVersion = 1;

    @Override
    public FVFont convertFont(FVFont font) throws IOException {
        this.otfFont = (OpenTypeFont)font;
        this.woffFont = WoffFont.createBlankFont(this.woffVersion);
        this.woffFont.addFont(font);
        this.addFontTables();
        return this.woffFont;
    }

    private void addFontTables() throws IOException {
        for (OpenTypeTable tableOn : this.otfFont.getTables()) {
            this.woffFont.addFontTable(tableOn.getUnpaddedData(), tableOn.getTableType(), tableOn.getChecksum());
        }
    }

    public static class OtfToWoff2Converter
    extends OtfToWoffConverter {
        public OtfToWoff2Converter() {
            this.woffVersion = 2;
        }
    }
}

