/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.cff;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.EncodedFont;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.encoding.Encoding;
import org.mabb.fontverter.CombinedFontConverter;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.FontConverter;
import org.mabb.fontverter.FontNotSupportedException;
import org.mabb.fontverter.FontProperties;
import org.mabb.fontverter.FontVerter;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.GlyphMapReader;
import org.mabb.fontverter.converter.CFFToOpenTypeConverter;
import org.mabb.fontverter.converter.OtfToWoffConverter;
import org.mabb.fontverter.validator.RuleValidator;

public class CffFontAdapter
implements FVFont {
    private byte[] data = new byte[0];
    private CFFFont font;

    public static CffFontAdapter parse(byte[] cffData) throws IOException {
        CFFFont cfffont = CffFontAdapter.fontboxParse(cffData);
        CffFontAdapter font = new CffFontAdapter(cfffont);
        font.setData(cffData);
        return font;
    }

    private static CFFFont fontboxParse(byte[] cffData) throws IOException {
        CFFParser parser = new CFFParser();
        List fonts = parser.parse(cffData);
        if (fonts.size() > 1) {
            throw new FontNotSupportedException("Multiple CFF fonts in one file are not supported.");
        }
        return (CFFFont)fonts.get(0);
    }

    public CffFontAdapter(CFFFont font) {
        this.font = font;
    }

    public CffFontAdapter() {
    }

    @Override
    public boolean detectFormat(byte[] fontFile) {
        try {
            CffFontAdapter.fontboxParse(fontFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void read(byte[] fontFile) throws IOException {
        this.font = CffFontAdapter.fontboxParse(fontFile);
        this.data = fontFile;
    }

    @Override
    public FontConverter createConverterForType(FontVerter.FontFormat fontFormat) throws FontNotSupportedException {
        if (fontFormat == FontVerter.FontFormat.OTF) {
            return new CFFToOpenTypeConverter(this);
        }
        if (fontFormat == FontVerter.FontFormat.WOFF1) {
            return new CombinedFontConverter(new CFFToOpenTypeConverter(this), new OtfToWoffConverter());
        }
        if (fontFormat == FontVerter.FontFormat.WOFF2) {
            return new CombinedFontConverter(new CFFToOpenTypeConverter(this), new OtfToWoffConverter.OtfToWoff2Converter());
        }
        throw new FontNotSupportedException("Font conversion not supported");
    }

    @Override
    public String getName() {
        return this.getFullName();
    }

    public CFFFont getFont() {
        return this.font;
    }

    public String getFullName() {
        String name = this.font.getName();
        if (name.isEmpty()) {
            name = this.nonNullDictEntry("FullName", String.class);
        }
        return name;
    }

    public String getFamilyName() {
        String name = this.nonNullDictEntry("FamilyName", String.class);
        if (name.isEmpty()) {
            name = this.nonNullDictEntry("FullName", String.class);
        }
        return name;
    }

    public String getSubFamilyName() {
        return this.nonNullDictEntry("Weight", String.class);
    }

    public String getVersion() {
        return this.nonNullDictEntry("version", String.class);
    }

    public String getTrademarkNotice() {
        return this.nonNullDictEntry("Notice", String.class);
    }

    public Integer getUnderLinePosition() {
        return this.nonNullDictEntry("UnderlinePosition", Integer.class);
    }

    public int getMinX() {
        return this.getBoundingBox().get(0);
    }

    public int getMinY() {
        return this.getBoundingBox().get(1);
    }

    public int getMaxX() {
        return this.getBoundingBox().get(2);
    }

    public int getMaxY() {
        return this.getBoundingBox().get(3);
    }

    private ArrayList<Integer> getBoundingBox() {
        Object obj = this.font.getTopDict().get("FontBBox");
        ArrayList boundingBox = null;
        if (obj != null && obj instanceof ArrayList) {
            boundingBox = (ArrayList)obj;
        }
        if (boundingBox == null || boundingBox.size() < 4) {
            boundingBox = this.createDefaultBoundingBox();
        }
        return boundingBox;
    }

    private ArrayList<Integer> createDefaultBoundingBox() {
        ArrayList<Integer> boundingBox = new ArrayList<Integer>();
        boundingBox.add(30);
        boundingBox.add(-2);
        boundingBox.add(1300);
        boundingBox.add(800);
        return boundingBox;
    }

    public Map<Integer, String> getGlyphIdsToNames() throws IOException {
        try {
            Field mapField = FontVerterUtils.findPrivateField("gidToName", CFFCharset.class);
            return (Map)mapField.get(this.font.getCharset());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public Map<Integer, Integer> getCharCodeToGlyphIds() throws IOException {
        try {
            Field mapField = FontVerterUtils.findPrivateField("sidOrCidToGid", CFFCharset.class);
            return (Map)mapField.get(this.font.getCharset());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public List<GlyphMapReader.GlyphMapping> getGlyphMaps() throws IOException {
        Map<Integer, String> glyphIdsToNames = this.getGlyphIdsToNames();
        if (glyphIdsToNames.size() != 0) {
            return GlyphMapReader.readGlyphsToNames(glyphIdsToNames, this.getEncoding());
        }
        return GlyphMapReader.readCharCodesToGlyphs(this.getCharCodeToGlyphIds(), this.getEncoding());
    }

    public Encoding getEncoding() {
        if (this.font instanceof EncodedFont) {
            try {
                return ((EncodedFont)this.font).getEncoding();
            }
            catch (IOException e) {
                return CFFStandardEncoding.getInstance();
            }
        }
        return CFFStandardEncoding.getInstance();
    }

    private <X> X nonNullDictEntry(String key, Class<X> type) {
        Object value = this.font.getTopDict().get(key);
        if (value != null) {
            return (X)value;
        }
        if (type == String.class) {
            return (X)"";
        }
        if (type == Integer.class) {
            return (X)new Integer(1);
        }
        return (X)"";
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public List<RuleValidator.FontValidatorError> getValidationErrors() {
        return new ArrayList<RuleValidator.FontValidatorError>();
    }

    @Override
    public FontProperties getProperties() {
        FontProperties properties = new FontProperties();
        properties.setMimeType("");
        properties.setFileEnding("cff");
        properties.setCssFontFaceFormat("");
        return properties;
    }

    public List<CffGlyph> getGlyphs() throws IOException {
        ArrayList<CffGlyph> glyphs = new ArrayList<CffGlyph>();
        for (GlyphMapReader.GlyphMapping mapOn : this.getGlyphMaps()) {
            CffGlyph glyph = this.createGlyph();
            Type2CharString charStr = this.font.getType2CharString(mapOn.glyphId.intValue());
            glyph.readType2Sequence(charStr.getType2Sequence());
            glyph.map = mapOn;
            glyph.charStr = charStr;
            glyphs.add(glyph);
        }
        return glyphs;
    }

    public Integer getDefaultWidth() {
        String key = "defaultWidthX";
        if (!this.getPrivateDict().containsKey(key)) {
            return 1000;
        }
        return (Integer)this.getPrivateDict().get(key);
    }

    public Integer getNominalWidth() {
        String key = "nominalWidthX";
        if (!this.getPrivateDict().containsKey(key)) {
            return 1000;
        }
        return (Integer)this.getPrivateDict().get(key);
    }

    Map<String, Object> getPrivateDict() {
        if (this.font instanceof CFFType1Font) {
            return ((CFFType1Font)this.font).getPrivateDict();
        }
        HashMap<String, Object> dict = new HashMap<String, Object>();
        for (Map dictOn : ((CFFCIDFont)this.font).getPrivDicts()) {
            dict.putAll(dictOn);
        }
        return dict;
    }

    public CffGlyph createGlyph() {
        CffGlyph glyph = new CffGlyph();
        glyph.nominalWidth = this.getNominalWidth();
        glyph.defaultWidth = this.getDefaultWidth();
        glyph.advancedWidth = this.getDefaultWidth();
        return glyph;
    }

    public static class CffGlyph {
        private int leftSideBearing = 0;
        private Integer advancedWidth;
        Integer nominalWidth;
        Integer defaultWidth;
        public GlyphMapReader.GlyphMapping map;
        public Type2CharString charStr;

        public int getLeftSideBearing() {
            return this.leftSideBearing;
        }

        public void setLeftSideBearing(int leftSideBearing) {
            this.leftSideBearing = leftSideBearing;
        }

        public int getAdvanceWidth() {
            return this.advancedWidth;
        }

        public void setAdvancedWidth(int advancedWidth) {
            this.advancedWidth = advancedWidth;
        }

        public void readType2Sequence(List<Object> type2Sequence) {
            Object firstObj = type2Sequence.get(0);
            this.advancedWidth = firstObj instanceof Integer ? Integer.valueOf(this.nominalWidth + (Integer)firstObj) : this.defaultWidth;
            this.parseHints(type2Sequence);
        }

        private void parseHints(List<Object> type2Sequence) {
            LinkedList<Command> commands = new LinkedList<Command>();
            Command commandOn = null;
            for (Object objOn : type2Sequence) {
                if (objOn instanceof CharStringCommand) {
                    CharStringCommand command = (CharStringCommand)objOn;
                    commandOn = new Command();
                    commandOn.name = command.toString();
                    commands.add(commandOn);
                    continue;
                }
                if (!(objOn instanceof Integer) || commandOn == null) continue;
                commandOn.values.add((Integer)objOn);
            }
            for (Command command : commands) {
                this.parseHint(command);
            }
        }

        private void parseHint(Command command) {
            if (command.name.startsWith("hstem")) {
                this.leftSideBearing = command.values.get(0);
            }
        }

        static class Command {
            String name;
            List<Integer> values = new LinkedList<Integer>();

            Command() {
            }
        }
    }
}

