package basic.framework.ability.log.client;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

import static basic.framework.ability.admin.client.utils.ConstantUtils.DEFAULT_FILTER_URL;


/**
 * @author panda
 */
public class AdminClientFilterEnabledCondition extends SpringBootCondition {
    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context,
                                            AnnotatedTypeMetadata annotatedTypeMetadata) {

        if (!isEnabled(context.getEnvironment())) {
            return ConditionOutcome.noMatch(
                    "Spring Boot Client is disabled, because 'spring.boot.log.client.filter.enabled' is false.");
        }

        if (isUrlEmpty(context.getEnvironment())) {
            return ConditionOutcome.noMatch(
                    "Spring Boot Client is disabled, because 'spring.boot.log.filter.url' is empty.");
        }

        return ConditionOutcome.match();
    }

    private boolean isEnabled(Environment env) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(env,
                "spring.boot.log.client.filter.");
        return resolver.getProperty("enabled", Boolean.class, Boolean.TRUE);
    }

    private boolean isUrlEmpty(Environment env) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver(env, "spring.boot.log.filter.");
        return StringUtils.isEmpty(resolver.getProperty("url", DEFAULT_FILTER_URL));
    }
}