package basic.framework.components.log.controller;


import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("logs")
public class LogsController {


    @RequestMapping(value = "/change/{level}", method = RequestMethod.GET)
    public String change(@PathVariable("level") String level, @RequestParam(required = false) String packages) {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        Logger logger = null;
        if (StringUtils.isEmpty(packages)) {
            packages = "root";
        }
        logger = loggerContext.getLogger(packages);
        logger.setLevel(Level.toLevel(level));
        logger.debug("debug");
        logger.info("info");
        logger.error("error");

        if ("root".equalsIgnoreCase(packages)) {
            return "全局日志级别修改为[" + level + "]";
        } else {
            return "包名[" + packages + "]日志级别修改为[" + level + "]";
        }
    }

    @RequestMapping(value = "/dubbo/access/{isOpen}", method = RequestMethod.GET)
    public String access(@PathVariable("isOpen") Boolean isOpen) {
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        Logger logger = loggerContext.getLogger("dubbo.accesslog");

        if (isOpen) {
            logger.setLevel(Level.toLevel("INFO"));
            return "dubbo访问日志打开";
        } else {
            logger.setLevel(Level.toLevel("ERROR"));
            return "dubbo访问日志关闭";
        }
    }
}