/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import net.luohuasheng.bee.rest.admin.client.utils.Base64;

public class RSA {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA1WithRSA";
    private static final String PUBLIC_KEY = "RSAPublicKey";
    private static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final Integer KEY_SIZE = 1024;

    public static Map<String, Object> initKey() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(KEY_SIZE);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
    }

    public static String sign(String signing, String privateKey, String charset) {
        try {
            return RSA.sign(signing.getBytes(charset), privateKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException(e);
        }
    }

    public static String sign(byte[] data, String privateKey) {
        try {
            byte[] keyBytes = RSA.base64Decode(privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(priKey);
            signature.update(data);
            return RSA.base64Encode(signature.sign());
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static boolean verify(String content, String sign, String publicKey, String charset) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            byte[] encodedKey = Base64.decode(publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(charset));
            return signature.verify(Base64.decode(sign));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        String content = "buyer_email=wusuoming@hotmail.com&buyer_id=2088002153808766&exterface=create_direct_pay_by_user&is_success=T&notify_id=RqPnCoPT3K9%2Fvwbh3InUHyjQBT8C%2FDR4ygx9l%2FSxpi1bg2PuBP%2BvlLInYw17WHVXOpH4&notify_time=2016-03-26 23:21:42&notify_type=trade_status_sync&out_trade_no=2016326231941206&payment_type=1&seller_email=249313652@qq.com&seller_id=2088221414620512&subject=\u6d4b\u8bd5\u8ba2\u5355-2016326231941206&total_fee=0.01&trade_no=2016032621001004760287981014&trade_status=TRADE_SUCCESS";
        String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCPwMqUq0i/jNxfhluKb3gL933ajmM8v4ScT6yYrkfV/1nH7FOECBPKNCzw8rECL//Rag+OxF1cnMbz1jfDPEfpQW+2XMi0BaECFJ5q7KhxampqyvMjg2OvY0FH40sMlwoG1BE9X156iC6QUyJetWE/346FnHDJw89EXc12E95K5QIDAQAB";
        String privateKey = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAI/AypSrSL+M3F+GW4pveAv3fdqOYzy/hJxPrJiuR9X/WcfsU4QIE8o0LPDysQIv/9FqD47EXVycxvPWN8M8R+lBb7ZcyLQFoQIUnmrsqHFqamrK8yODY69jQUfjSwyXCgbUET1fXnqILpBTIl61YT/fjoWccMnDz0RdzXYT3krlAgMBAAECgYB90A/9GgPrkc7109OeT3zTjGIbvG7iJgRcAedfIXlBs+DR9uYJMkCPwiZrIx0Eexn8IEVJgFbtzVDa6+uV9dZA1JaMZtUIrN/ioT4CoEFJCoEDg3B0QGoq/vfgdc8d45SWr2FqIlWVHRgdM0H1ULbjriVVfvvVbop/xz/Oru3QAQJBAP4qO+JBZJpHCMVpm2NYQ8n8ZszBBCbv8d+PMeIMOfjakLSuXHyuK2pwJbGngtW9Q1VOFsjPoj5BB/4x3bwpbOUCQQCQynx2in1/bu9sP/pq5sBy7DnMmdSpRVEW41FLnPGm4Kh1axoRr/syNyma1WD9aL/KlGVqtjEpGKo2vp9fkYYBAkAeo0CsuW1DG6T3Bw/wHceuJXrO28WAXBQv+rbspMSoNtCStyH29ZfOMM6aZ7LhyPrA4bTlaAIKtxQblC9Ca0vxAkBTFT3SL6nPw/Jy5UtmqD5qM47/Do5vCy16urndb5NitKs1pV1yJM85g1nGVQaworjbH8gKMb2H3XVesId3KWQBAkEAj8aVhv67a8VIFYz2T7Oqche9yyW+UKo29zbG2jeXIWkR5z33f0Vml8Lqyj/h6Q2OkqkUoUSx1WBaYkNkbUqNqg==";
        String sign = RSA.sign(content, privateKey, "utf-8");
        Boolean isFlag = RSA.verify(content, sign, publicKey, "utf-8");
        System.out.println(isFlag);
    }

    public static byte[] decryptByPrivateKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] decryptByPublicKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static byte[] encryptByPrivateKey(byte[] data, String key) {
        try {
            byte[] keyBytes = RSA.base64Decode(key);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static String getPrivateKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PRIVATE_KEY);
        return RSA.base64Encode(key.getEncoded());
    }

    public static String getPublicKey(Map<String, Object> keyMap) {
        Key key = (Key)keyMap.get(PUBLIC_KEY);
        return RSA.base64Encode(key.getEncoded());
    }

    public static String base64Encode(byte[] key) {
        return Base64.encode(key);
    }

    public static byte[] base64Decode(String key) {
        return Base64.decode(key);
    }
}

