/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Queue<T> {
    private Integer maxSize;
    private LinkedList<T> ll = new LinkedList();

    public Queue(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Queue() {
        this.maxSize = Integer.MAX_VALUE;
    }

    @SafeVarargs
    public final void put(T ... values) {
        for (T value : values) {
            this.ll.addLast(value);
            if (this.ll.size() <= this.maxSize) continue;
            this.ll.removeFirst();
        }
    }

    public T get() {
        return this.ll.removeFirst();
    }

    public List<T> getAll() {
        return new ArrayList<T>(this.ll);
    }

    public boolean empty() {
        return this.ll.isEmpty();
    }

    public static void main(String[] args) {
        Queue<String> mq = new Queue<String>();
        mq.put("e", "a", "b", "d");
        while (!mq.empty()) {
            System.out.println((String)mq.get());
        }
    }
}

