/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.utils;

import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CookieUtils {
    public static Cookie[] getCookies() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Cookie[] c = request.getCookies();
        return c;
    }

    public static void showCookie() {
        Cookie[] c = CookieUtils.getCookies();
        for (int i = 0; i < (c == null ? 0 : c.length); ++i) {
            System.out.println("\u4e00\u6761cookie____  name: " + c[i].getName() + "  || value: " + c[i].getValue());
        }
    }

    public static void saveCookie(Cookie cookie) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = attributes.getResponse();
        response.addCookie(cookie);
    }

    public static void addCookie(String name, String value) {
        CookieUtils.addCookie(name, value, Integer.MAX_VALUE);
    }

    public static void addCookie(String name, String value, int expiry) {
        try {
            String v = URLEncoder.encode(value, "UTF-8");
            Cookie cookie = new Cookie(name, v);
            cookie.setPath("/");
            cookie.setMaxAge(expiry);
            CookieUtils.saveCookie(cookie);
        }
        catch (Exception e) {
            System.out.println(" -------\u6dfb\u52a0cookie \u5931\u8d25\uff01--------" + e.getMessage());
        }
    }

    public static String getCookie(String name) {
        try {
            Cookie[] cookies = CookieUtils.getCookies();
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                return URLDecoder.decode(cookies[i].getValue(), "UTF-8");
            }
        }
        catch (Exception e) {
            System.out.println(" --------\u83b7\u53d6String cookie \u5931\u8d25--------   " + e.getMessage());
        }
        return null;
    }

    public static void removeCookie(String name) {
        try {
            Cookie[] cookies = CookieUtils.getCookies();
            for (int i = 0; i < (cookies == null ? 0 : cookies.length); ++i) {
                if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
                Cookie cookie = new Cookie(name, "");
                cookie.setPath("/");
                cookie.setMaxAge(0);
                CookieUtils.saveCookie(cookie);
            }
        }
        catch (Exception e) {
            System.out.println(" -------\u5220\u9664cookie\u5931\u8d25\uff01--------" + e.getMessage());
        }
    }
}

