/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.endpoint;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.utils.NetworkUtils;
import net.luohuasheng.bee.rest.admin.client.utils.RSA;
import net.luohuasheng.bee.rest.admin.client.utils.RequestUtils;
import net.luohuasheng.bee.rest.admin.client.utils.id.IdUtil;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@RestControllerEndpoint(id="sign")
public class SignEndPoint {
    private final ClientProperties clientProperties;
    private final Long id = IdUtil.getId();

    public SignEndPoint(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @GetMapping(value={"/sign"})
    public Map<String, Object> sign(HttpServletRequest request) {
        String ip = NetworkUtils.getIpAddr(request);
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        map.put("version", this.clientProperties.getSignVersion());
        map.put("id", this.id);
        map.put("value", RSA.base64Encode(RSA.encryptByPublicKey(ip.getBytes(), this.clientProperties.getSignKey())));
        return map;
    }

    @GetMapping(value={"/edit"})
    public Map<?, ?> edit(@RequestParam Integer version, @RequestParam String publicKey, HttpServletResponse response) {
        this.clientProperties.setSignKey(publicKey);
        this.clientProperties.setSignVersion(version);
        return RequestUtils.ok(response);
    }

    @PostMapping(value={"/edit"})
    public Object edit2(Integer version, String publicKey, HttpServletResponse response) {
        return this.edit(version, publicKey, response);
    }

    @GetMapping(value={"/verify"})
    public boolean verify(@RequestParam String consoleToken, HttpServletRequest request) {
        String ip = NetworkUtils.getIpAddr(request);
        return RSA.verify(ip + "_" + System.currentTimeMillis() / 3600000L, consoleToken, this.clientProperties.getSignKey(), StandardCharsets.UTF_8.name());
    }
}

