/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.hardware.NetworkIF;

public class NetworkDto {
    private static Map<String, NetworkDto> netDtoMap = new HashMap<String, NetworkDto>();
    private String name;
    private String ipv4addr;
    private Long bytesRecv;
    private Long bytesSent;
    private Long packetsRecv;
    private Long packetsSent;
    private Long rxSpeed = 0L;
    private Long txSpeed = 0L;
    private Long rxbSpeed = 0L;
    private Long txbSpeed = 0L;

    private static List<NetworkDto> loadNetDto() {
        ArrayList<NetworkDto> netDtos = new ArrayList<NetworkDto>();
        for (NetworkIF networkIF : SystemInfoUtils.getNetworkIFs()) {
            NetworkDto netDto = new NetworkDto();
            Object[] ipv4addrs = networkIF.getIPv4addr();
            if (ArrayUtils.isEmpty((Object[])ipv4addrs)) continue;
            netDto.ipv4addr = ipv4addrs[0];
            netDto.name = networkIF.getName();
            netDto.bytesRecv = networkIF.getBytesRecv();
            netDto.bytesSent = networkIF.getBytesSent();
            netDto.packetsRecv = networkIF.getPacketsRecv();
            netDto.packetsSent = networkIF.getPacketsSent();
            netDtos.add(netDto);
        }
        return netDtos;
    }

    public static List<NetworkDto> createNetDtos() {
        ArrayList<NetworkDto> netDtos = new ArrayList<NetworkDto>();
        for (Map.Entry<String, NetworkDto> stringNetworkDtoEntry : netDtoMap.entrySet()) {
            netDtos.add(stringNetworkDtoEntry.getValue());
        }
        return netDtos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIpv4addr() {
        return this.ipv4addr;
    }

    public void setIpv4addr(String ipv4addr) {
        this.ipv4addr = ipv4addr;
    }

    public Long getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(Long bytesRecv) {
        this.bytesRecv = bytesRecv;
    }

    public Long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(Long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public Long getPacketsRecv() {
        return this.packetsRecv;
    }

    public void setPacketsRecv(Long packetsRecv) {
        this.packetsRecv = packetsRecv;
    }

    public Long getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(Long packetsSent) {
        this.packetsSent = packetsSent;
    }

    public Long getRxSpeed() {
        return this.rxSpeed;
    }

    public void setRxSpeed(Long rxSpeed) {
        this.rxSpeed = rxSpeed;
    }

    public Long getTxSpeed() {
        return this.txSpeed;
    }

    public void setTxSpeed(Long txSpeed) {
        this.txSpeed = txSpeed;
    }

    public Long getRxbSpeed() {
        return this.rxbSpeed;
    }

    public void setRxbSpeed(Long rxbSpeed) {
        this.rxbSpeed = rxbSpeed;
    }

    public Long getTxbSpeed() {
        return this.txbSpeed;
    }

    public void setTxbSpeed(Long txbSpeed) {
        this.txbSpeed = txbSpeed;
    }

    static {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("net-schedule-pool-%d").daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            HashMap<String, NetworkDto> netDtoMapTmp = new HashMap<String, NetworkDto>();
            List<NetworkDto> netDtos = NetworkDto.loadNetDto();
            for (NetworkDto netDto : netDtos) {
                NetworkDto netDto1 = netDtoMap.get(netDto.getName());
                netDtoMapTmp.put(netDto.getName(), netDto);
                if (netDto1 == null) continue;
                netDto.rxSpeed = netDto.bytesRecv - netDto1.bytesRecv;
                netDto.txSpeed = netDto.bytesSent - netDto1.bytesSent;
                netDto.rxbSpeed = netDto.packetsRecv - netDto1.packetsRecv;
                netDto.txbSpeed = netDto.packetsSent - netDto1.packetsSent;
            }
            netDtoMap = netDtoMapTmp;
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

