/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.luohuasheng.bee.rest.admin.client.utils.SystemInfoUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import oshi.hardware.CentralProcessor;

public class CpuDto {
    private static final Map<String, Long> SYSTEM_CPU_LOAD_TICKS_MAP = new HashMap<String, Long>();
    private static final Map<String, Double> CPU_PRESENT = new HashMap<String, Double>();
    private static final String TOTAL_CPU_KEY = "totalCpu";
    private static final String CPU_SCHEDULE_POOL_KEY = "totalCpu";
    private static final String USER_PRESENT = "userPrecent";
    private static final String SYS_PRESENT = "sysPrecent";
    private static final String IDLE_PRESENT = "idlePrecent";
    private static final Integer LOAD_AVERAGE_LENGTH = 3;
    private Long uptime;
    private Double usedPrecent;
    private Double userPrecent;
    private Double sysPrecent;
    private Double idlePrecent;
    private Double oneMinute;
    private Double fiveMinute;
    private Double fifteenMinute;

    public CpuDto() {
        CentralProcessor processor = SystemInfoUtils.getProcessor();
        this.uptime = processor.getMaxFreq();
        this.userPrecent = CPU_PRESENT.get(USER_PRESENT);
        this.sysPrecent = CPU_PRESENT.get(SYS_PRESENT);
        this.idlePrecent = CPU_PRESENT.get(IDLE_PRESENT);
        this.usedPrecent = 0.0;
        double[] loadAverage = processor.getSystemLoadAverage(LOAD_AVERAGE_LENGTH.intValue());
        if (loadAverage != null && loadAverage.length == LOAD_AVERAGE_LENGTH) {
            this.oneMinute = loadAverage[0];
            this.fiveMinute = loadAverage[1];
            this.fifteenMinute = loadAverage[2];
        }
    }

    public Long getUptime() {
        return this.uptime;
    }

    public void setUptime(Long uptime) {
        this.uptime = uptime;
    }

    public Double getOneMinute() {
        return this.oneMinute;
    }

    public void setOneMinute(Double oneMinute) {
        this.oneMinute = oneMinute;
    }

    public Double getFiveMinute() {
        return this.fiveMinute;
    }

    public void setFiveMinute(Double fiveMinute) {
        this.fiveMinute = fiveMinute;
    }

    public Double getFifteenMinute() {
        return this.fifteenMinute;
    }

    public void setFifteenMinute(Double fifteenMinute) {
        this.fifteenMinute = fifteenMinute;
    }

    public Double getUsedPrecent() {
        return this.usedPrecent;
    }

    public void setUsedPrecent(Double usedPrecent) {
        this.usedPrecent = usedPrecent;
    }

    public Double getUserPrecent() {
        return this.userPrecent;
    }

    public void setUserPrecent(Double userPrecent) {
        this.userPrecent = userPrecent;
    }

    public Double getSysPrecent() {
        return this.sysPrecent;
    }

    public void setSysPrecent(Double sysPrecent) {
        this.sysPrecent = sysPrecent;
    }

    public Double getIdlePrecent() {
        return this.idlePrecent;
    }

    public void setIdlePrecent(Double idlePrecent) {
        this.idlePrecent = idlePrecent;
    }

    static {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("totalCpu").daemon(true).build());
        executorService.scheduleAtFixedRate(() -> {
            long[] ticks = SystemInfoUtils.getProcessor().getSystemCpuLoadTicks();
            Long prevUser = SYSTEM_CPU_LOAD_TICKS_MAP.get(CentralProcessor.TickType.USER.name());
            if (prevUser != null) {
                Long prevSys = SYSTEM_CPU_LOAD_TICKS_MAP.get(CentralProcessor.TickType.SYSTEM.name());
                Long prevIdle = SYSTEM_CPU_LOAD_TICKS_MAP.get(CentralProcessor.TickType.IDLE.name());
                Long prevTotalCpu = SYSTEM_CPU_LOAD_TICKS_MAP.get("totalCpu");
                Long user = ticks[CentralProcessor.TickType.USER.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.USER.name(), user);
                Long nice = ticks[CentralProcessor.TickType.NICE.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.NICE.name(), nice);
                Long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.SYSTEM.name(), sys);
                Long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IDLE.name(), idle);
                Long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IOWAIT.name(), iowait);
                Long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IRQ.name(), irq);
                Long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.SOFTIRQ.name(), softirq);
                Long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.STEAL.name(), steal);
                Long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
                SYSTEM_CPU_LOAD_TICKS_MAP.put("totalCpu", totalCpu);
                if (totalCpu > prevTotalCpu) {
                    CPU_PRESENT.put(USER_PRESENT, 1.0 * (double)(user - prevUser) / (double)(totalCpu - prevTotalCpu));
                    CPU_PRESENT.put(SYS_PRESENT, 1.0 * (double)(sys - prevSys) / (double)(totalCpu - prevTotalCpu));
                    CPU_PRESENT.put(IDLE_PRESENT, 1.0 * (double)(idle - prevIdle) / (double)(totalCpu - prevTotalCpu));
                }
            } else {
                Long user = ticks[CentralProcessor.TickType.USER.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.USER.name(), user);
                Long nice = ticks[CentralProcessor.TickType.NICE.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.NICE.name(), nice);
                Long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.SYSTEM.name(), sys);
                Long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IDLE.name(), idle);
                Long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IOWAIT.name(), iowait);
                Long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.IRQ.name(), irq);
                Long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.SOFTIRQ.name(), softirq);
                Long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()];
                SYSTEM_CPU_LOAD_TICKS_MAP.put(CentralProcessor.TickType.STEAL.name(), steal);
                Long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
                SYSTEM_CPU_LOAD_TICKS_MAP.put("totalCpu", totalCpu);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

