/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.dto.db;

import net.luohuasheng.bee.rest.admin.client.dto.db.process.MysqlProcess;
import net.luohuasheng.bee.rest.admin.client.dto.db.process.OracleProcess;
import net.luohuasheng.bee.rest.admin.client.dto.db.process.PostgresProcess;
import net.luohuasheng.bee.rest.admin.client.dto.db.process.SqlServerProcess;

public enum MonitorDbType {
    MYSQL("mysql", "SHOW FULL PROCESSLIST", "SHOW GLOBAL VARIABLES", "SHOW GLOBAL STATUS", MysqlProcess.class),
    MARIADB("mariadb", "SHOW FULL PROCESSLIST", "SHOW GLOBAL VARIABLES", "SHOW GLOBAL STATUS", MysqlProcess.class),
    ORACLE("oracle", "SELECT S.SID \"Id\", S.SERIAL# \"Serial\", S.USERNAME \"User\", S.MACHINE \"Host\", A.NAME \"Command\", S.LAST_CALL_ET \"Time\", S.STATUS \"State\", S.EVENT \"Info\" FROM V$SESSION S, AUDIT_ACTIONS A WHERE A.ACTION = S.COMMAND ORDER BY S.SID", "SELECT*FROM (\nSELECT NAME,VALUE FROM V$SYSTEM_PARAMETER2 UNION ALL \nSELECT 'START_TIME' name,TO_CHAR(ceil((SYSDATE-startup_time)*24*60*60)) value FROM sys.v_$instance UNION ALL \nSELECT 'VERSION' name,version value FROM sys.v_$instance) ORDER BY NAME", "SELECT NAME  , VALUE   FROM V$SYSSTAT ORDER BY NAME", OracleProcess.class),
    DM("dm", "SELECT A.SESS_ID id,A.SQL_TEXT info,A.USER_NAME \"user\",A.CURR_SCH db,A.STATE state,A.SEQ_NO seq,A.CLNT_HOST clientHost,A.APPNAME appName,A.OSNAME osName,B.IP_ADDR host, -1 TIME FROM SYS.V$SESSIONS A,SYS.V$CONNECT B WHERE A.Sess_id =B.SADDR ORDER BY SF_GET_EP_SEQNO (A.rowid),A.Sess_id", "SELECT PARA_NAME NAME,PARA_VALUE VALUE FROM \"SYS\".\"V$DM_INI\" UNION ALL SELECT 'DB_VERSION',REPLACE (BANNER,'DB Version: ','') FROM \"SYS\".\"V$VERSION\" WHERE BANNER LIKE 'DB Version%';", "select name,stat_val value from \"SYS\".\"V$SYSSTAT\"", SqlServerProcess.class),
    SQLSERVER("sqlserver", "SELECT spid id,TRIM (sp.[status]) state,TRIM (loginame) [user],TRIM (hostname) host,TRIM (sd.name) db,TRIM (cmd) info,cpu [time] FROM master.dbo.sysprocesses sp JOIN master.dbo.sysdatabases sd ON sp.dbid =sd.dbid ORDER BY spid", "", "", SqlServerProcess.class),
    POSTGRESQL("postgresql", "SELECT a.pid AS \"Id\", a.usename AS \"User\", a.client_addr AS \"Host\", a.client_port AS \"Port\", datname AS \"db\", query AS \"Command\", l.mode AS \"State\", FLOOR(  extract(  epoch FROM (  now()-query_start)) ) AS \"Time\", CASE WHEN c.relname IS NOT NULL THEN 'Locked Object: ' || c.relname ELSE 'Locked Transaction: ' || l.virtualtransaction END AS \"Info\" FROM pg_stat_activity a LEFT JOIN pg_locks l ON a.pid = l.pid LEFT JOIN pg_class c ON l.relation = c.oid ORDER BY a.pid ASC, c.relname ASC", "SHOW ALL", "SELECT 'db_numbackends' AS name,pg_stat_get_db_numbackends (datid) AS value FROM pg_stat_database WHERE datname=current_database () UNION ALL \nSELECT 'db_xact_commit',pg_stat_get_db_xact_commit (datid) FROM pg_stat_database WHERE datname=current_database () UNION ALL \nSELECT 'db_xact_rollback',pg_stat_get_db_xact_rollback (datid) FROM pg_stat_database WHERE datname=current_database () UNION ALL \nSELECT 'db_blocks_fetched',pg_stat_get_db_blocks_fetched (datid) FROM pg_stat_database WHERE datname=current_database () UNION ALL \nSELECT 'db_blocks_hit',pg_stat_get_db_blocks_hit (datid) FROM pg_stat_database WHERE datname=current_database () ", PostgresProcess.class);

    private String type;
    private String processSql;
    private String variablesSql;
    private String statusSql;
    private Class<?> processClass;

    private MonitorDbType(String type, String processSql, String variablesSql, String statusSql, Class<?> processClass) {
        this.type = type;
        this.processSql = processSql;
        this.variablesSql = variablesSql;
        this.statusSql = statusSql;
        this.processClass = processClass;
    }

    public static MonitorDbType type(String type) {
        for (MonitorDbType value : MonitorDbType.values()) {
            if (!value.type.equals(type)) continue;
            return value;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getProcessSql() {
        return this.processSql;
    }

    public String getVariablesSql() {
        return this.variablesSql;
    }

    public String getStatusSql() {
        return this.statusSql;
    }

    public Class<?> getProcessClass() {
        return this.processClass;
    }
}

