/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.rest.admin.client.config;

import io.micrometer.core.instrument.LocalMeterRegistry;
import javax.servlet.Filter;
import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.config.ClientWebConfig;
import net.luohuasheng.bee.rest.admin.client.interceptor.ClientFilter;
import net.luohuasheng.bee.rest.admin.client.interceptor.SqlInterceptor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestContextListener;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@PropertySource(value={"classpath:client.properties", "classpath:git.properties"}, ignoreResourceNotFound=true)
@ComponentScan(value={"net.luohuasheng.bee.rest.admin.client"})
@EnableConfigurationProperties(value={ClientProperties.class})
@Import(value={ClientWebConfig.class})
public class ClientConfig {
    @Bean
    public LocalMeterRegistry simpleMeterRegistry() {
        return new LocalMeterRegistry();
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    @Order(value=400)
    public SqlInterceptor sqlInterceptor() {
        return new SqlInterceptor();
    }

    @Bean
    public FilterRegistrationBean customFilter() {
        FilterRegistrationBean filterBean = new FilterRegistrationBean();
        filterBean.setFilter((Filter)new ClientFilter());
        filterBean.setName("FilterController");
        filterBean.addUrlPatterns(new String[]{"/*"});
        return filterBean;
    }
}

