/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.cumulative.CumulativeCounter;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import io.micrometer.core.instrument.internal.DefaultMeter;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.step.StepCounter;
import io.micrometer.core.instrument.step.StepDistributionSummary;
import io.micrometer.core.instrument.step.StepFunctionCounter;
import io.micrometer.core.instrument.step.StepFunctionTimer;
import io.micrometer.core.instrument.step.StepTimer;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import javax.servlet.http.HttpServletRequest;
import net.luohuasheng.bee.rest.admin.client.config.ClientProperties;
import net.luohuasheng.bee.rest.admin.client.dto.application.ResponseStatusDto;
import net.luohuasheng.bee.rest.admin.client.dto.application.ResponseTimeDto;
import net.luohuasheng.bee.rest.admin.client.interceptor.ClientFilter;
import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LocalMeterRegistry
extends MeterRegistry {
    @Autowired
    private ClientProperties clientProperties;
    private final SimpleConfig config;
    private final Map<String, ResponseStatusDto> statusMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, ResponseTimeDto> timeMap = Collections.synchronizedMap(new HashMap());

    public LocalMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    private LocalMeterRegistry(SimpleConfig config, Clock clock) {
        super(clock);
        config.requireValid();
        this.config = config;
        this.config().meterFilter(MeterFilter.acceptNameStartsWith((String)"http"));
    }

    private void loadResponseTimeDto(String uri, Long thisTime) {
        ResponseTimeDto responseTimeDto = this.timeMap.get(uri);
        if (responseTimeDto == null) {
            responseTimeDto = new ResponseTimeDto();
            responseTimeDto.setUri(uri);
            this.timeMap.put(uri, responseTimeDto);
        }
        Long total = responseTimeDto.getTotal().addAndGet(thisTime);
        Long maxTime = responseTimeDto.getMaxTime();
        if (thisTime > maxTime) {
            responseTimeDto.setMaxTime(thisTime);
        }
        Long all = responseTimeDto.getAll().incrementAndGet();
        responseTimeDto.setTime(total / all);
        if (thisTime < 200L) {
            responseTimeDto.getLessTwoHundred().incrementAndGet();
        } else if (thisTime < 500L) {
            responseTimeDto.getLessFiveHundred().incrementAndGet();
        } else if (thisTime < 1000L) {
            responseTimeDto.getLessOneThousand().incrementAndGet();
        } else {
            responseTimeDto.getGreaterOneThousand().incrementAndGet();
        }
    }

    private void loadResponseStatusDto(String uri, String statusKey) {
        ResponseStatusDto responseStatusDto = this.statusMap.get(uri);
        if (responseStatusDto == null) {
            responseStatusDto = new ResponseStatusDto();
            responseStatusDto.setUri(uri);
            this.statusMap.put(uri, responseStatusDto);
        }
        responseStatusDto.getAll().incrementAndGet();
        if ("1".equals(statusKey)) {
            responseStatusDto.getS1().incrementAndGet();
        } else if ("2".equals(statusKey)) {
            responseStatusDto.getS2().incrementAndGet();
        } else if ("3".equals(statusKey)) {
            responseStatusDto.getS3().incrementAndGet();
        } else if ("4".equals(statusKey)) {
            responseStatusDto.getS4().incrementAndGet();
        } else if ("5".equals(statusKey)) {
            responseStatusDto.getS5().incrementAndGet();
        }
    }

    Timer timer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetectorOverride) {
        Timer timer = super.timer(id, distributionStatisticConfig, pauseDetectorOverride);
        if ("http.server.requests".equals(id.getName())) {
            try {
                Object value = ClientFilter.LOCAL_TIMING_CONTEXT.get();
                ClientFilter.LOCAL_TIMING_CONTEXT.remove();
                if (value == null) {
                    RequestAttributes requestAttribute = RequestContextHolder.getRequestAttributes();
                    HttpServletRequest request = ((ServletRequestAttributes)requestAttribute).getRequest();
                    value = request.getAttribute("org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetricsFilter$TimingContext");
                }
                if (value != null) {
                    Timer.Sample timerSample = (Timer.Sample)FieldUtils.getFieldValue("timerSample", value);
                    long startTime = (Long)FieldUtils.getFieldValue("startTime", timerSample);
                    Clock clock = (Clock)FieldUtils.getFieldValue("clock", timerSample);
                    Long thisTime = (long)TimeUtils.nanosToUnit((double)(clock.monotonicTime() - startTime), (TimeUnit)TimeUnit.MILLISECONDS);
                    String statusKey = null;
                    String uri = null;
                    for (Tag tag : timer.getId().getTags()) {
                        if ("status".equals(tag.getKey())) {
                            statusKey = tag.getValue().substring(0, 1);
                            continue;
                        }
                        if (!"uri".equals(tag.getKey())) continue;
                        uri = tag.getValue();
                    }
                    if (!(StringUtils.isEmpty(uri) || uri.contains("/actuator") || uri.contains("/favicon.ico") || "root".equalsIgnoreCase(uri) || "/**".equalsIgnoreCase(uri) || uri.contains("api-docs") || uri.contains(this.clientProperties.getName()) || uri.contains("/admin-ui") || uri.contains("swagger"))) {
                        if (!StringUtils.isEmpty((Object)statusKey)) {
                            this.loadResponseStatusDto(uri, statusKey);
                        }
                        this.loadResponseTimeDto(uri, thisTime);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return timer;
    }

    public Map<String, ResponseStatusDto> getStatusMap() {
        return this.statusMap;
    }

    public Map<String, ResponseTimeDto> getTimeMap() {
        return this.timeMap;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        CumulativeDistributionSummary summary;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                summary = new CumulativeDistributionSummary(id, this.clock, merged, scale, false);
                break;
            }
            default: {
                summary = new StepDistributionSummary(id, this.clock, merged, scale, this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat((DistributionSummary)summary, (MeterRegistry)this);
        return summary;
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        CumulativeTimer timer;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                timer = new CumulativeTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), false);
                break;
            }
            default: {
                timer = new StepTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat((Timer)timer, (MeterRegistry)this);
        return timer;
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat((LongTaskTimer)ltt, (MeterRegistry)this);
        return ltt;
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
            }
        }
        return new StepFunctionTimer(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionCounter(id, obj, countFunction);
            }
        }
        return new StepFunctionCounter(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

