package net.luohuasheng.bee.rest.admin.client.utils;

import oshi.SystemInfo;
import oshi.hardware.*;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

import java.util.List;

/**
 * 系统信息工具类
 *
 * @author panda
 * @date 2018-12-30
 */
public class SystemInfoUtils {

    private static SystemInfo systemInfo = new SystemInfo();

    /**
     * 获取硬件抽象层信息
     *
     * @return 硬件抽象层信息
     */
    private static HardwareAbstractionLayer getHardware() {
        return systemInfo.getHardware();
    }

    /**
     * 获取操作系统信息
     *
     * @return 操作系统信息
     */
    public static OperatingSystem getOperatingSystem() {
        return systemInfo.getOperatingSystem();
    }

    /**
     * 获取系统信息
     *
     * @return 系统信息
     */
    public static ComputerSystem getComputerSystem() {
        return getHardware().getComputerSystem();
    }

    /**
     * 获取CPU信息
     *
     * @return CPU信息
     */
    public static CentralProcessor getProcessor() {
        return getHardware().getProcessor();
    }

    /**
     * 获取内存信息
     *
     * @return 内存信息
     */
    public static GlobalMemory getMemory() {
        return getHardware().getMemory();
    }

    /**
     * 获取电源信息
     *
     * @return 电源信息
     */
    public static List<PowerSource> getPowerSources() {
        return getHardware().getPowerSources();
    }

    /**
     * 获取磁盘信息
     *
     * @return 磁盘信息
     */
    public static List<HWDiskStore> getDiskStores() {
        return getHardware().getDiskStores();
    }

    /**
     * 获取网卡信息
     *
     * @return 网卡信息
     */
    public static List<NetworkIF> getNetworkIFs() {
        return getHardware().getNetworkIFs();
    }

    /**
     * 获取显卡信息
     *
     * @return 显卡信息
     */
    public static List<Display> getDisplays() {
        return getHardware().getDisplays();
    }

    /**
     * 获取传感器信息
     *
     * @return 传感器信息
     */
    public static Sensors getSensors() {
        return getHardware().getSensors();
    }

    /**
     * 获取外接USB信息
     *
     * @param tree 是否树显示
     * @return USB信息
     */
    public static List<UsbDevice> getUsbDevices(boolean tree) {
        return getHardware().getUsbDevices(tree);
    }

    /**
     * 获取声卡信息
     *
     * @return 声卡信息
     */
    public static List<SoundCard> getSoundCards() {
        return getHardware().getSoundCards();
    }

    public static List<OSProcess> getProcesses() {
        return getOperatingSystem().getProcesses(getOperatingSystem().getProcessCount(), OperatingSystem.ProcessSort.CPU);
    }

    public static List<OSProcess> getProcesses(int limit) {
        return getOperatingSystem().getProcesses(limit, OperatingSystem.ProcessSort.CPU);
    }

    public static List<OSProcess> getProcesses(int limit, OperatingSystem.ProcessSort processSort) {
        return getOperatingSystem().getProcesses(limit, processSort);
    }

    public static List<OSProcess> getProcesses(OperatingSystem.ProcessSort processSort) {
        return getOperatingSystem().getProcesses(getOperatingSystem().getProcessCount(), processSort);
    }
}
