package net.luohuasheng.bee.rest.admin.client.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * @author panda
 */
public class Queue<T> {

    private Integer maxSize;

    private LinkedList<T> ll = new LinkedList<>();

    public Queue(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Queue() {
        this.maxSize = Integer.MAX_VALUE;
    }

    @SafeVarargs
    public final void put(T... values) {
        for (T value : values) {
            ll.addLast(value);
            if (ll.size() > maxSize) {
                ll.removeFirst();
            }
        }
    }

    public T get() {
        return ll.removeFirst();
    }

    public List<T> getAll() {
        return new ArrayList<>(ll);
    }

    public boolean empty() {
        return ll.isEmpty();
    }

    public static void main(String[] args) {
        Queue<String> mq = new Queue<>();
        mq.put("e", "a", "b", "d");
        while (!mq.empty()) {
            System.out.println(mq.get());
        }
    }
} 