package net.luohuasheng.bee.rest.admin.client.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

/**
 * json工具类
 *
 * @author panda
 * @date 2019-06-27
 */
public class JsonUtils {
    public static String toJson(Object target) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return mapper.writeValueAsString(target);
        } catch (IOException e) {
            throw null;
        }
    }
}
