package net.luohuasheng.bee.rest.admin.client.utils;

import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

/**
 * 属性操作类
 *
 * @author panda
 * @date 2019-06-26
 */
public class FieldUtils {

    public static Object getFieldValue(String fieldName, Object value) {
        try {
            Field field = value.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            value = ReflectionUtils.getField(field, value);
            field.setAccessible(false);
            return value;
        } catch (NoSuchFieldException e) {
            return null;
        }

    }

    public static Object getFieldValue(Object value, String fieldName) {
        return getFieldValue(fieldName, value);

    }

    public static void setFieldValue(String fieldName, Object target, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            ReflectionUtils.setField(field, target, value);
            field.setAccessible(false);
        } catch (NoSuchFieldException ignored) {
        }
    }
}
