package net.luohuasheng.bee.rest.admin.client.utils;


import net.luohuasheng.bee.jdbc.tools.component.structure.dto.TableDto;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.*;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Db2Word {


    public static void exportDoc(List<List<TableDto>> tableDtos, OutputStream out) {
        File outTempFile = null;
        try {

            outTempFile = File.createTempFile("temp", ".xml");
            TemplateTools.createFile(getTableValue(tableDtos), "dbTemplateDoc.ftl", outTempFile.getCanonicalPath());
            ZipInputStream zipInputStream = ZipTools.wrapZipInputStream(Db2Word.class.getClassLoader().getResourceAsStream("template.docx"));
            ZipOutputStream zipOutputStream = ZipTools.wrapZipOutputStream(out);
            String itemname = "word/document.xml";
            ZipTools.replaceItem(zipInputStream, zipOutputStream, itemname, new FileInputStream(new File(outTempFile.getCanonicalPath())));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (outTempFile != null) {
                outTempFile.deleteOnExit();
            }
        }
    }


    public static void exportHtml(List<List<TableDto>> tableDtos, OutputStream out) {
        File outTempFile = null;
        try {

            outTempFile = File.createTempFile("temp", ".html");
            TemplateTools.createFile(getTableValue(tableDtos), "dbTemplateHtml.ftl", outTempFile.getCanonicalPath());
            FileCopyUtils.copy(new FileInputStream(outTempFile), out);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (outTempFile != null) {
                outTempFile.deleteOnExit();//程序退出时删除临时文件
            }
        }
    }

    private static Map<String, Object> getTableValue(List<List<TableDto>> tableDtos) {
        Map<String, Object> data = new TreeMap<>();
        Map<String, Map<String, TableDto>> map = new TreeMap<>();
        for (List<TableDto> tableDto : tableDtos) {
            for (TableDto dto : tableDto) {
                String user = StringUtils.isEmpty(dto.getTableCat()) ? dto.getTableSchem() : dto.getTableCat();
                String tableName = dto.getTableName();
                Map<String, TableDto> userMap = map.get(user);
                if (userMap == null) {
                    userMap = new TreeMap<>();
                    map.put(user, userMap);
                    userMap.put(tableName, dto);
                } else {
                    userMap.putIfAbsent(tableName, dto);
                }
            }
        }
        Map<String, List<TableDto>> users = new HashMap<>();
        for (Map.Entry<String, Map<String, TableDto>> stringMapEntry : map.entrySet()) {
            users.put(stringMapEntry.getKey(), new ArrayList<>(map.get(stringMapEntry.getKey()).values()));
        }
        data.put("tableUsers", users);
        return data;
    }


}
