package net.luohuasheng.bee.rest.admin.client.utils;

import java.util.Date;

/**
 * @author wusuoming
 */
public class DateDistanceUtils {


    /**
     * 两个时间相差距离多少天多少小时多少分多少秒
     *
     * @param one 时间参数 1 格式：1990-01-01 12:00:00
     * @param two 时间参数 2 格式：2009-01-01 12:00:00
     * @return String 返回值为：xx天xx小时xx分xx秒
     */
    public static String getDistanceTime(Date one, Date two) {
        long time1 = one.getTime();
        long time2 = two.getTime();
        long diff;
        if (time1 < time2) {
            diff = time2 - time1;
        } else {
            diff = time1 - time2;
        }
        return (getDistanceTime(diff));
    }

    public static String getDistanceTime(Long diff) {
        long day, hour, min, sec;
        day = diff / (24 * 60 * 60 * 1000);
        hour = (diff / (60 * 60 * 1000) - day * 24);
        min = ((diff / (60 * 1000)) - day * 24 * 60 - hour * 60);
        sec = (diff / 1000 - day * 24 * 60 * 60 - hour * 60 * 60 - min * 60);
        return (day == 0 ? "" : day + "天") + (hour == 0 ? "" : hour + "小时") + (min == 0 ? "" : min + "分") + (sec == 0 ? "" : sec + "秒");
    }
}  
