//package net.luohuasheng.bee.rest.admin.client.service;
//
//
//import net.luohuasheng.bee.rest.admin.client.utils.FieldUtils;
//import com.google.common.base.Strings;
//import com.google.common.collect.Lists;
//import io.swagger.models.Operation;
//import io.swagger.models.Path;
//import io.swagger.models.Swagger;
//import io.swagger.models.Tag;
//import org.checkerframework.checker.units.qual.C;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.ApplicationContext;
//import org.springframework.context.annotation.Bean;
//import org.springframework.stereotype.Component;
//import org.springframework.stereotype.Service;
//import org.springframework.util.ReflectionUtils;
//import org.springframework.util.StringUtils;
//import org.springframework.web.util.UriComponents;
//import springfox.documentation.service.Documentation;
//import springfox.documentation.spring.web.DocumentationCache;
//import springfox.documentation.spring.web.PropertySourcedRequestMappingHandlerMapping;
//import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
//import springfox.documentation.swagger2.web.Swagger2Controller;
//
//import javax.annotation.PostConstruct;
//import javax.servlet.http.HttpServletRequest;
//import java.util.Map;
//
//import static com.google.common.base.Strings.isNullOrEmpty;
//import static springfox.documentation.swagger.common.HostNameProvider.componentsFrom;
//
///**
// * Swagger服务
// *
// * @author panda
// * @date 2019-06-08
// */
//@Component
//public class SwaggerService {
//    private static final String DEFAULT = "DEFAULT";
//    private String hostNameOverride;
//    private DocumentationCache documentationCache;
//    private ServiceModelToSwagger2Mapper mapper;
//    private Swagger2Controller swagger2Controller;
//
//
//    @Autowired
//    private ApplicationContext applicationContext;
//
//
//    @PostConstruct
//    public void init() {
//        PropertySourcedRequestMappingHandlerMapping requestMappingHandlerMapping = applicationContext.getBean("swagger2ControllerMapping", PropertySourcedRequestMappingHandlerMapping.class);
//        swagger2Controller = (Swagger2Controller) FieldUtils.getFieldValue(requestMappingHandlerMapping, "handler");
//        hostNameOverride = (String) FieldUtils.getFieldValue(swagger2Controller, "hostNameOverride");
//        documentationCache = (DocumentationCache) FieldUtils.getFieldValue(swagger2Controller, "documentationCache");
//        mapper = (ServiceModelToSwagger2Mapper) FieldUtils.getFieldValue(swagger2Controller, "mapper");
//    }
//
//    public Swagger getSwagger(HttpServletRequest servletRequest) {
//        Swagger retSwagger = null;
//        String path = servletRequest.getHeader("path");
//
//
//        for (Map.Entry<String, Documentation> stringDocumentationEntry : documentationCache.all().entrySet()) {
//            if (!StringUtils.isEmpty(servletRequest.getParameter("group")) && !stringDocumentationEntry.getKey().equals(servletRequest.getParameter("group"))) {
//                continue;
//            }
//            Documentation documentation = stringDocumentationEntry.getValue();
//            if (documentation == null) {
//                return null;
//            }
//            Swagger swagger = mapper.mapDocumentation(documentation);
//            UriComponents uriComponents = componentsFrom(servletRequest, swagger.getBasePath());
//            if (!StringUtils.isEmpty(path)) {
//                swagger.basePath(path);
//            } else {
//                swagger.basePath(Strings.isNullOrEmpty(uriComponents.getPath()) ? "/" : uriComponents.getPath());
//            }
//            if (isNullOrEmpty(swagger.getHost())) {
//                swagger.host(hostName(uriComponents));
//            }
//
//            if (retSwagger == null) {
//                retSwagger = swagger;
//                retSwagger.setTags(Lists.newArrayList());
//            } else {
//                retSwagger.getDefinitions().putAll(swagger.getDefinitions());
//                retSwagger.getPaths().putAll(swagger.getPaths());
//            }
//        }
//        for (Path value : retSwagger.getPaths().values()) {
//            for (Operation operation : value.getOperations()) {
//                for (String tag : operation.getTags()) {
//                    boolean isContains = false;
//                    for (Tag swaggerTag : retSwagger.getTags()) {
//                        if (swaggerTag.getName().equals(tag)) {
//                            isContains = true;
//                        }
//                    }
//                    if (!isContains) {
//                        retSwagger.getTags().add(new Tag().name(tag).description(tag));
//                    }
//                }
//
//            }
//
//        }
//        return retSwagger;
//    }
//
//    private String hostName(UriComponents uriComponents) {
//        if (DEFAULT.equals(hostNameOverride)) {
//            String host = uriComponents.getHost();
//            int port = uriComponents.getPort();
//            if (port > -1) {
//                return String.format("%s:%d", host, port);
//            }
//            return host;
//        }
//        return hostNameOverride;
//    }
//
//}
