package net.luohuasheng.bee.rest.admin.client.interceptor;

import net.luohuasheng.bee.rest.admin.client.aop.DynamicAdvice;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

/**
 * sql监控
 *
 * @author panda
 * @date 2019-01-14
 */

@Intercepts({
        @Signature(method = "query", type = Executor.class, args = {
                MappedStatement.class, Object.class, RowBounds.class,
                ResultHandler.class}),
        @Signature(method = "update", type = Executor.class, args = {
                MappedStatement.class, Object.class})})
public class SqlInterceptor implements Interceptor {
    private static final Map<String, Method> METHOD_MAP = new ConcurrentHashMap<>();
    private static final Map<String, Class> CLASS_MAP = new ConcurrentHashMap<>();


    private Logger logger = LoggerFactory.getLogger(SqlInterceptor.class);


    @Autowired
    private ApplicationContext applicationContext;


    @Autowired
    private DynamicAdvice dynamicAdvice;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement) invocation.getArgs()[0];
        addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.before);
        Object value = null;
        try {
            value = invocation.proceed();
        } catch (Exception e) {
            addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.exception);
            throw e;
        }
        addSqlMethod(mappedStatement.getId(), DynamicAdvice.CallType.after);
        return value;
    }

    private void addSqlMethod(String id, DynamicAdvice.CallType type) throws ClassNotFoundException {
        if (dynamicAdvice == null) {
            dynamicAdvice = applicationContext.getBean(DynamicAdvice.class);
        }
        Method method = getMethod(id);
        if (DynamicAdvice.CallType.before.equals(type)) {
            dynamicAdvice.beforeValue(CLASS_MAP.get(id), method, true);
        } else {
            dynamicAdvice.returnValue(CLASS_MAP.get(id), method, type);
        }
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {
        // 合并属性
    }


    private Method getMethod(String id) throws ClassNotFoundException {
        Method method = METHOD_MAP.get(id);
        if (method == null) {
            int index = id.lastIndexOf(".");
            String className = id.substring(0, index);
            String methodName = id.substring(index + 1);
            Class classZ = Class.forName(className);
            for (Method method2 : classZ.getMethods()) {
                if (method2.getName().equals(methodName)) {
                    METHOD_MAP.put(id, method2);
                    CLASS_MAP.put(id, classZ);
                    return method2;
                }
            }
        } else {
            return method;
        }
        throw new RuntimeException("not fond method");
    }


}
