package net.luohuasheng.bee.rest.admin.client.interceptor;

import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author wusuoming
 */
@Order(100)
@WebFilter(filterName = "clientFilter", urlPatterns = {"*"})
public class ClientFilter implements Filter {

    public static final ThreadLocal<Object> LOCAL_TIMING_CONTEXT = new ThreadLocal<>();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        RequestAttributes requestAttribute = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ((ServletRequestAttributes) requestAttribute).getRequest();
        Object value = request.getAttribute("org.springframework.boot.actuate.metrics.web.servlet.WebMvcMetricsFilter$TimingContext");
        LOCAL_TIMING_CONTEXT.set(value);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
    }
}