package net.luohuasheng.bee.rest.admin.client.enums;

import org.springframework.util.StringUtils;


/**
 * Description: 系统方法
 *
 * @author panda
 * @version 2015年11月25日 | 0.0.1
 */
public enum SystemMethod {
    /**
     * 登录
     */
    LOGIN("login", "登录"),
    /**
     * 修改密码
     */
    RSET_PWD("rsetPwd", "修改密码"),
    /**
     * 注销
     */
    LOGOUT("logout", "注销"),
    ;


    private String code;

    private String description;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private SystemMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static SystemMethod getTypeByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (SystemMethod element : SystemMethod.values()) {
            if (element.getCode().equals(code)) {
                return element;
            }
        }
        return null;
    }

}
