package net.luohuasheng.bee.rest.admin.client.enums;

import org.springframework.util.StringUtils;


/**
 * Description: 系统方法
 *
 * @author panda
 * @version 2015年11月25日 | 0.0.1
 */
public enum LogbackMethod {
    /**
     * 修改级别
     */
    LEVEL("level", "修改级别"),
    /**
     * 过滤级别
     */
    FILTER("filter", "过滤级别"),
    /**
     * 全量载入文件
     */
    LOAD_FILE("loadFile", "全量载入文件"),
    /**
     * 实时载入文件
     */
    TAIL_FILE("tailFile", "实时载入文件"),
    /**
     * 下载文件
     */
    DOWNLOAD_FILE("downloadFile", "下载文件"),
    /**
     * 所有文件列表
     */
    LIST("list", "所有文件列表"),
    /**
     * 获取CSS文件
     */
    GET_CSS_FILE("getCssFile", "获取CSS文件"),
    ;


    private String code;

    private String description;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private LogbackMethod(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static LogbackMethod getTypeByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        for (LogbackMethod element : LogbackMethod.values()) {
            if (element.getCode().equals(code)) {
                return element;
            }
        }
        return null;
    }

}
